package com.xforceplus.ultraman.app.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单据模板
 * </p>
 *
 * @author ultraman
 * @since 2022-06-13
 */
public enum BillTemplate {

    FINANCIAL_TRAVEL_APPLY_BILL("financialTravelApplyBill", "差旅申请单"),
    FINANCIAL_BUSINESS_SERVE_APPLY_BILL("financialBusinessServeApplyBill", "业务招待申请单"),
    FINANCIAL_TRAVEL_REIMBURSEMENT_BILL("financialTravelReimbursementBill", "差旅报销单"),
    FINANCIAL_CITY_REIMBURSEMENT_BILL("financialCityReimbursementBill", "市内交通报销单"),
    FINANCIAL_BUSINESS_SERVE_REIMBURSEMENT_BILL("financialBusinessServeReimbursementBill", "业务招待报销单"),
    FINANCIAL_HES_WRITEOFF_BILL("financialHesWriteoffBill", "合思订单核销单");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BillTemplate(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillTemplate fromCode(String code){
        switch(code) {
            case "financialTravelApplyBill":
                return FINANCIAL_TRAVEL_APPLY_BILL;
            case "financialBusinessServeApplyBill":
                return FINANCIAL_BUSINESS_SERVE_APPLY_BILL;
            case "financialTravelReimbursementBill":
                return FINANCIAL_TRAVEL_REIMBURSEMENT_BILL;
            case "financialCityReimbursementBill":
                return FINANCIAL_CITY_REIMBURSEMENT_BILL;
            case "financialBusinessServeReimbursementBill":
                return FINANCIAL_BUSINESS_SERVE_REIMBURSEMENT_BILL;
            case "financialHesWriteoffBill":
                return FINANCIAL_HES_WRITEOFF_BILL;
            default:
                return null;
        }
    }
}
