package com.xforceplus.ultraman.app.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单据模本明细
 * </p>
 *
 * @author ultraman
 * @since 2022-06-13
 */
public enum BillTemplateDetail {

    FINANCIAL_TRAVEL_APPLY_BILL_DETAIL("financialTravelApplyBillDetail", "差旅申请单"),
    FINANCIAL_TRAVEL_BILL_DETAIL("financialTravelBillDetail", "差旅报销单"),
    FINANCIAL_CITY_BILL_DETAIL("financialCityBillDetail", " 市内交通费报销单"),
    FINANCIAL_BUSINESS_SERVE_BILL_DETAIL("financialBusinessServeBillDetail", "业务招待报销单"),
    FINANCIAL_HES_WRITEOFF_BILL_DETAIL("financialHesWriteoffBillDetail", " 合思订单核销单");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BillTemplateDetail(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillTemplateDetail fromCode(String code){
        switch(code) {
            case "financialTravelApplyBillDetail":
                return FINANCIAL_TRAVEL_APPLY_BILL_DETAIL;
            case "financialTravelBillDetail":
                return FINANCIAL_TRAVEL_BILL_DETAIL;
            case "financialCityBillDetail":
                return FINANCIAL_CITY_BILL_DETAIL;
            case "financialBusinessServeBillDetail":
                return FINANCIAL_BUSINESS_SERVE_BILL_DETAIL;
            case "financialHesWriteoffBillDetail":
                return FINANCIAL_HES_WRITEOFF_BILL_DETAIL;
            default:
                return null;
        }
    }
}
