package com.xforceplus.ultraman.app.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 计费周期
 * </p>
 *
 * @author ultraman
 * @since 2022-06-13
 */
public enum ChargeCycleEnum {

    YEAR("YEAR", "年");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ChargeCycleEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChargeCycleEnum fromCode(String code){
        switch(code) {
            case "YEAR":
                return YEAR;
            default:
                return null;
        }
    }
}
