package com.xforceplus.ultraman.app.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 计费业务维度
 * </p>
 *
 * @author ultraman
 * @since 2022-07-12
 */
public enum ChargeBizDimensionEnum {

    CERTIFICATION_TIMES("CERTIFICATION_TIMES", "认证次数"),
    CERTIFICATE_INVOICE_PIECES("CERTIFICATE_INVOICE_PIECES", "认证发票张数"),
    VERIFY_TIMES("VERIFY_TIMES", "验真次数"),
    VERIFY_INVOICE_PIECES("VERIFY_INVOICE_PIECES", "验真发票张数"),
    MAKE_OUT_INVOICE_PIECES("MAKE_OUT_INVOICE_PIECES", "开票张数"),
    OCR_TIMES("OCR_TIMES", "识别次数"),
    FILE("FILE", "文件服务");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ChargeBizDimensionEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChargeBizDimensionEnum fromCode(String code){
        switch(code) {
            case "CERTIFICATION_TIMES":
                return CERTIFICATION_TIMES;
            case "CERTIFICATE_INVOICE_PIECES":
                return CERTIFICATE_INVOICE_PIECES;
            case "VERIFY_TIMES":
                return VERIFY_TIMES;
            case "VERIFY_INVOICE_PIECES":
                return VERIFY_INVOICE_PIECES;
            case "MAKE_OUT_INVOICE_PIECES":
                return MAKE_OUT_INVOICE_PIECES;
            case "OCR_TIMES":
                return OCR_TIMES;
            case "FILE":
                return FILE;
            default:
                return null;
        }
    }
}
