package com.xforceplus.ultraman.app.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 设备类型枚举
 * </p>
 *
 * @author ultraman
 * @since 2022-07-12
 */
public enum DeviceTypeEnum {

    CORE_BOARD("CORE_BOARD", "核心板"),
    TAX_DISK("TAX_DISK", "税盘"),
    UKEY("UKEY", "Ukey"),
    SOFT_CERTIFICATE("SOFT_CERTIFICATE", "软证书"),
    TAX_SERVER("TAX_SERVER", "服务器");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DeviceTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DeviceTypeEnum fromCode(String code){
        switch(code) {
            case "CORE_BOARD":
                return CORE_BOARD;
            case "TAX_DISK":
                return TAX_DISK;
            case "UKEY":
                return UKEY;
            case "SOFT_CERTIFICATE":
                return SOFT_CERTIFICATE;
            case "TAX_SERVER":
                return TAX_SERVER;
            default:
                return null;
        }
    }
}
