package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-07-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ChargeCodePrimeCost implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 月份
   */
  @TableField("projectMonth")
  private String projectMonth;

  /**
   * Chargecode
   */
  @TableField("chargeCode")
  private String chargeCode;

  /**
   * Chargecode描述
   */
  @TableField("chargeCodeName")
  private String chargeCodeName;

  /**
   * chargeCode描述
   */
  @TableField("chargeCodeDesc")
  private String chargeCodeDesc;

  /**
   * 部门编号
   */
  @TableField("departmentCode")
  private String departmentCode;

  /**
   * 部门名称
   */
  @TableField("departmentName")
  private String departmentName;

  /**
   * 人工成本汇总金额
   */
  @TableField("totalAmount")
  private String totalAmount;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 成本月份时间
   */
  @TableField("projectMonthTime")
  private String projectMonthTime;

  /**
   * 人工成本汇总金额web
   */
  @TableField("totalAmountWeb")
  private BigDecimal totalAmountWeb;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("projectMonth", projectMonth);
      map.put("chargeCode", chargeCode);
      map.put("chargeCodeName", chargeCodeName);
      map.put("chargeCodeDesc", chargeCodeDesc);
      map.put("departmentCode", departmentCode);
      map.put("departmentName", departmentName);
      map.put("totalAmount", totalAmount);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("projectMonthTime", projectMonthTime);
      map.put("totalAmountWeb", totalAmountWeb);
      return map;
  }

  public static ChargeCodePrimeCost fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ChargeCodePrimeCost entity = new ChargeCodePrimeCost();
    if(map.containsKey("projectMonth")) {
      Object obj = map.get("projectMonth");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectMonth((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeCode")) {
      Object obj = map.get("chargeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeCodeName")) {
      Object obj = map.get("chargeCodeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeCodeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeCodeDesc")) {
      Object obj = map.get("chargeCodeDesc");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeCodeDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("departmentCode")) {
      Object obj = map.get("departmentCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDepartmentCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("departmentName")) {
      Object obj = map.get("departmentName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDepartmentName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalAmount")) {
      Object obj = map.get("totalAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTotalAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectMonthTime")) {
      Object obj = map.get("projectMonthTime");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectMonthTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalAmountWeb")) {
      Object obj = map.get("totalAmountWeb");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmountWeb((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmountWeb(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmountWeb(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTotalAmountWeb(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmountWeb(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    return entity;
  }
}
