package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialApplyBasicBill;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-07-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class FinancialResponsibleChangeBill extends FinancialApplyBasicBill {


  /**
   * 采购事项单据单号
   */
  @TableField("procurementDocumentsNo")
  private String procurementDocumentsNo;

  /**
   * 采购事项单据标题
   */
  @TableField("procurementDocumentsTitle")
  private String procurementDocumentsTitle;

  /**
   * 变更后责任人编码
   */
  @TableField("changeResponsibleCode")
  private String changeResponsibleCode;

  /**
   * 变更后责任人名称
   */
  @TableField("changeResponsibleName")
  private String changeResponsibleName;

  /**
   * 申请人部门
   */
  @TableField("applicationDept")
  private String applicationDept;

  /**
   * 变更说明
   */
  @TableField("changeCause")
  private String changeCause;

  /**
   * 采购单号
   */
  @TableField("procurementNo")
  private String procurementNo;

  /**
   * 签约主体
   */
  @TableField("contractParty")
  private String contractParty;

  /**
   * 供应商名称
   */
  @TableField("supplierName")
  private String supplierName;

  /**
   * 合同编号
   */
  @TableField("contractNo")
  private String contractNo;

  /**
   * 验收方式编码
   */
  @TableField("checkWayCode")
  private String checkWayCode;

  /**
   * 验收方式名称
   */
  @TableField("checkWayName")
  private String checkWayName;

  /**
   * 项目文本
   */
  @TableField("projectTxt")
  private String projectTxt;

  /**
   * 采购类别编码
   */
  @TableField("procurementTypeCode")
  private String procurementTypeCode;

  /**
   * 采购类别名称
   */
  @TableField("procurementTypeName")
  private String procurementTypeName;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("procurementDocumentsNo", procurementDocumentsNo);
      map.put("procurementDocumentsTitle", procurementDocumentsTitle);
      map.put("changeResponsibleCode", changeResponsibleCode);
      map.put("changeResponsibleName", changeResponsibleName);
      map.put("applicationDept", applicationDept);
      map.put("changeCause", changeCause);
      map.put("procurementNo", procurementNo);
      map.put("contractParty", contractParty);
      map.put("supplierName", supplierName);
      map.put("contractNo", contractNo);
      map.put("checkWayCode", checkWayCode);
      map.put("checkWayName", checkWayName);
      map.put("projectTxt", projectTxt);
      map.put("procurementTypeCode", procurementTypeCode);
      map.put("procurementTypeName", procurementTypeName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static FinancialResponsibleChangeBill fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    FinancialResponsibleChangeBill entity = new FinancialResponsibleChangeBill();
    if(map.containsKey("applicationDate")) {
      Object obj = map.get("applicationDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApplicationDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setApplicationDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setApplicationDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setApplicationDate(null);
      }
    }
    if(map.containsKey("applicantDept")) {
      Object obj = map.get("applicantDept");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplicantDept((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applicantCompanyCode")) {
      Object obj = map.get("applicantCompanyCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplicantCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applicantCompanyName")) {
      Object obj = map.get("applicantCompanyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplicantCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("procurementDocumentsNo")) {
      Object obj = map.get("procurementDocumentsNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcurementDocumentsNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementDocumentsTitle")) {
      Object obj = map.get("procurementDocumentsTitle");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcurementDocumentsTitle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("changeResponsibleCode")) {
      Object obj = map.get("changeResponsibleCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChangeResponsibleCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("changeResponsibleName")) {
      Object obj = map.get("changeResponsibleName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChangeResponsibleName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applicationDept")) {
      Object obj = map.get("applicationDept");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplicationDept((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("changeCause")) {
      Object obj = map.get("changeCause");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChangeCause((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementNo")) {
      Object obj = map.get("procurementNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcurementNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractParty")) {
      Object obj = map.get("contractParty");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractParty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierName")) {
      Object obj = map.get("supplierName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSupplierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkWayCode")) {
      Object obj = map.get("checkWayCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckWayCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkWayName")) {
      Object obj = map.get("checkWayName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckWayName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectTxt")) {
      Object obj = map.get("projectTxt");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectTxt((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementTypeCode")) {
      Object obj = map.get("procurementTypeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcurementTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementTypeName")) {
      Object obj = map.get("procurementTypeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcurementTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
