package com.xforceplus.ultraman.app.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * chargeCode类型
 * </p>
 *
 * @author ultraman
 * @since 2022-07-18
 */
public enum ChargeCodeTypeEnum {

    SA("SA", "客户"),
    PS("PS", "机会"),
    DL("DL", "交付"),
    CSM("CSM", "客户成功"),
    BU("BU", "BU"),
    IDLE("IDLE", "空闲"),
    SMB("SMB", "小B运营"),
    SS("SS", "销售"),
    TR("TR", "培训"),
    BG("BG", "数据增值"),
    CO("CO", "总裁办"),
    EB("EB", "生态业务筹备组"),
    FA("FA", "财务部"),
    GM("GM", "综合管理"),
    GS("GS", "光是"),
    HL("HL", "休假"),
    HR("HR", "人事部"),
    JF("JF", "交付管理"),
    KF("KF", "客户服务部"),
    OM("OM", "运维"),
    PD("PD", "产品"),
    PE("PE", "商联"),
    RD("RD", "研发"),
    SL("SL", "解决方案"),
    SO("SO", "战略运营中心"),
    SQ("SQ", "售前");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ChargeCodeTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChargeCodeTypeEnum fromCode(String code){
        switch(code) {
            case "SA":
                return SA;
            case "PS":
                return PS;
            case "DL":
                return DL;
            case "CSM":
                return CSM;
            case "BU":
                return BU;
            case "IDLE":
                return IDLE;
            case "SMB":
                return SMB;
            case "SS":
                return SS;
            case "TR":
                return TR;
            case "BG":
                return BG;
            case "CO":
                return CO;
            case "EB":
                return EB;
            case "FA":
                return FA;
            case "GM":
                return GM;
            case "GS":
                return GS;
            case "HL":
                return HL;
            case "HR":
                return HR;
            case "JF":
                return JF;
            case "KF":
                return KF;
            case "OM":
                return OM;
            case "PD":
                return PD;
            case "PE":
                return PE;
            case "RD":
                return RD;
            case "SL":
                return SL;
            case "SO":
                return SO;
            case "SQ":
                return SQ;
            default:
                return null;
        }
    }
}
