package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-07-18
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Organize implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 组织编号
   */
  @TableField("orgCode")
  private String orgCode;

  /**
   * 组织负责人
   */
  @TableField("ownerName")
  private String ownerName;

  /**
   * 组织负责人工号
   */
  @TableField("ownerNo")
  private String ownerNo;

  /**
   * 上级组织
   */
  @TableField("parentOrgName")
  private String parentOrgName;

  /**
   * 上级组织编号
   */
  @TableField("parentOrgCode")
  private String parentOrgCode;

  /**
   * 状态
   */
  private String status;

  /**
   * 组织名称
   */
  @TableField("orgName")
  private String orgName;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 创建日期
   */
  @TableField("establishDate")
  private String establishDate;

  /**
   * 更新日期
   */
  @TableField("changeDate")
  private String changeDate;

  /**
   * 组织节点层级
   */
  @TableField("orgLevel")
  private String orgLevel;

  /**
   * 级别序列
   */
  @TableField("orgLevelSeria")
  private String orgLevelSeria;

  /**
   * 组织id
   */
  @TableField("orgId")
  private String orgId;

  /**
   * 组织负责人id
   */
  @TableField("ownerId")
  private String ownerId;

  /**
   * 上级组织id
   */
  @TableField("parentOrgId")
  private String parentOrgId;

  /**
   * 创建日期web
   */
  @TableField("establishDateWeb")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime establishDateWeb;

  /**
   * 更新日期web
   */
  @TableField("changeDateWeb")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime changeDateWeb;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("orgCode", orgCode);
      map.put("ownerName", ownerName);
      map.put("ownerNo", ownerNo);
      map.put("parentOrgName", parentOrgName);
      map.put("parentOrgCode", parentOrgCode);
      map.put("status", status);
      map.put("orgName", orgName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("establishDate", establishDate);
      map.put("changeDate", changeDate);
      map.put("orgLevel", orgLevel);
      map.put("orgLevelSeria", orgLevelSeria);
      map.put("orgId", orgId);
      map.put("ownerId", ownerId);
      map.put("parentOrgId", parentOrgId);
      map.put("establishDateWeb", BocpGenUtils.toTimestamp(establishDateWeb));
      map.put("changeDateWeb", BocpGenUtils.toTimestamp(changeDateWeb));
      return map;
  }

  public static Organize fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Organize entity = new Organize();
    if(map.containsKey("orgCode")) {
      Object obj = map.get("orgCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ownerName")) {
      Object obj = map.get("ownerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOwnerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ownerNo")) {
      Object obj = map.get("ownerNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOwnerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("parentOrgName")) {
      Object obj = map.get("parentOrgName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setParentOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("parentOrgCode")) {
      Object obj = map.get("parentOrgCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setParentOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orgName")) {
      Object obj = map.get("orgName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("establishDate")) {
      Object obj = map.get("establishDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEstablishDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("changeDate")) {
      Object obj = map.get("changeDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChangeDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orgLevel")) {
      Object obj = map.get("orgLevel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrgLevel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orgLevelSeria")) {
      Object obj = map.get("orgLevelSeria");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrgLevelSeria((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orgId")) {
      Object obj = map.get("orgId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrgId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ownerId")) {
      Object obj = map.get("ownerId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOwnerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("parentOrgId")) {
      Object obj = map.get("parentOrgId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setParentOrgId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("establishDateWeb")) {
      Object obj = map.get("establishDateWeb");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEstablishDateWeb(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setEstablishDateWeb((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setEstablishDateWeb(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEstablishDateWeb(null);
      }
    }
    if(map.containsKey("changeDateWeb")) {
      Object obj = map.get("changeDateWeb");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChangeDateWeb(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setChangeDateWeb((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setChangeDateWeb(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setChangeDateWeb(null);
      }
    }
    return entity;
  }
}
