package com.xforceplus.ultraman.app.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 人员状态
 * </p>
 *
 * @author ultraman
 * @since 2022-07-21
 */
public enum MemberStatusEnum {

    _1("1", "在职"),
    _2("2", "试用"),
    _3("3", "正式"),
    _4("4", "调出"),
    _5("5", "待调入"),
    _6("6", "退休"),
    _8("8", "离职"),
    _12("12", "非正式");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    MemberStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MemberStatusEnum fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "8":
                return _8;
            case "12":
                return _12;
            default:
                return null;
        }
    }
}
