package com.xforceplus.ultraman.app.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 服务开通标识
 * </p>
 *
 * @author ultraman
 * @since 2022-07-21
 */
public enum ServiceOpenFlag {

    FIRST_USE("FIRST_USE", "首次使用"),
    SIGN_CONTRACT("SIGN_CONTRACT", "合同签订"),
    PROJECT_FINISH("PROJECT_FINISH", "项目验收");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ServiceOpenFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ServiceOpenFlag fromCode(String code){
        switch(code) {
            case "FIRST_USE":
                return FIRST_USE;
            case "SIGN_CONTRACT":
                return SIGN_CONTRACT;
            case "PROJECT_FINISH":
                return PROJECT_FINISH;
            default:
                return null;
        }
    }
}
