package com.xforceplus.ultraman.app.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 小B支付方式
 * </p>
 *
 * @author ultraman
 * @since 2022-07-21
 */
public enum SmallPaymentType {

    OFFLINE("OFFLINE", "线下支付"),
    ALIPAY("ALIPAY", "支付宝支付"),
    BAOFU("BAOFU", "宝付"),
    BAOFU_WECHAT("BAOFU_WECHAT", "宝付-微信支付"),
    BAOFU_ALIPAY("BAOFU_ALIPAY", "宝付-支付宝支付"),
    BAOFU_WECHAT_MP("BAOFU_WECHAT_MP", "宝付-微信公众号支付");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SmallPaymentType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SmallPaymentType fromCode(String code){
        switch(code) {
            case "OFFLINE":
                return OFFLINE;
            case "ALIPAY":
                return ALIPAY;
            case "BAOFU":
                return BAOFU;
            case "BAOFU_WECHAT":
                return BAOFU_WECHAT;
            case "BAOFU_ALIPAY":
                return BAOFU_ALIPAY;
            case "BAOFU_WECHAT_MP":
                return BAOFU_WECHAT_MP;
            default:
                return null;
        }
    }
}
