package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialApplyBasicBill;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-07-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class FinancialSalaryBill extends FinancialApplyBasicBill {


  /**
   * 核票责任人编码
   */
  @TableField("verificationDutyCode")
  private String verificationDutyCode;

  /**
   * 核票责任人名称
   */
  @TableField("verificationDutyName")
  private String verificationDutyName;

  /**
   * 申请部门
   */
  @TableField("applicationDept")
  private String applicationDept;

  /**
   * 申请事由
   */
  private String cause;

  /**
   * applicationDate  
   */
  private String describe;

  /**
   * 供应商编码
   */
  @TableField("supplierCode")
  private String supplierCode;

  /**
   * 供应商名称
   */
  @TableField("supplierName")
  private String supplierName;

  /**
   * 收款银行
   */
  @TableField("dueBank")
  private String dueBank;

  /**
   * 收款账号
   */
  @TableField("accountNumber")
  private String accountNumber;

  /**
   * 收款人
   */
  private String payee;

  /**
   * 付款主体编码
   */
  @TableField("paymentCode")
  private String paymentCode;

  /**
   * 付款主体名称
   */
  @TableField("paymentName")
  private String paymentName;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("verificationDutyCode", verificationDutyCode);
      map.put("verificationDutyName", verificationDutyName);
      map.put("applicationDept", applicationDept);
      map.put("cause", cause);
      map.put("describe", describe);
      map.put("supplierCode", supplierCode);
      map.put("supplierName", supplierName);
      map.put("dueBank", dueBank);
      map.put("accountNumber", accountNumber);
      map.put("payee", payee);
      map.put("paymentCode", paymentCode);
      map.put("paymentName", paymentName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static FinancialSalaryBill fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    FinancialSalaryBill entity = new FinancialSalaryBill();
    if(map.containsKey("applicationDate")) {
      Object obj = map.get("applicationDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApplicationDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setApplicationDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setApplicationDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setApplicationDate(null);
      }
    }
    if(map.containsKey("applicantDept")) {
      Object obj = map.get("applicantDept");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplicantDept((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applicantCompanyCode")) {
      Object obj = map.get("applicantCompanyCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplicantCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applicantCompanyName")) {
      Object obj = map.get("applicantCompanyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplicantCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("verificationDutyCode")) {
      Object obj = map.get("verificationDutyCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVerificationDutyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verificationDutyName")) {
      Object obj = map.get("verificationDutyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVerificationDutyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applicationDept")) {
      Object obj = map.get("applicationDept");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplicationDept((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cause")) {
      Object obj = map.get("cause");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCause((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("describe")) {
      Object obj = map.get("describe");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDescribe((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierCode")) {
      Object obj = map.get("supplierCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSupplierCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierName")) {
      Object obj = map.get("supplierName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSupplierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dueBank")) {
      Object obj = map.get("dueBank");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDueBank((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountNumber")) {
      Object obj = map.get("accountNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAccountNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payee")) {
      Object obj = map.get("payee");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayee((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentCode")) {
      Object obj = map.get("paymentCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentName")) {
      Object obj = map.get("paymentName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
