package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 结算单明细表-税号
 * </p>
 *
 * @author ultraman
 * @since 2022-08-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BillDetail implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 对账单明细单号
   */
  @TableField("billDetailNo")
  private String billDetailNo;

  /**
   * 合同号
   */
  @TableField("contractNo")
  private String contractNo;

  /**
   * 产品编号
   */
  @TableField("productNo")
  private String productNo;

  /**
   * 计费类型
   */
  @TableField("chargeType")
  private String chargeType;

  /**
   * 付费方式
   */
  @TableField("paymentMethod")
  private String paymentMethod;

  /**
   * 售价（不含税）
   */
  @TableField("salePriceWithoutTax")
  private BigDecimal salePriceWithoutTax;

  /**
   * 单价（不含税）
   */
  @TableField("unitAmountWithoutTax")
  private BigDecimal unitAmountWithoutTax;

  /**
   * 本期应结算金额（含税）
   */
  @TableField("currentPayableAmountWithTax")
  private BigDecimal currentPayableAmountWithTax;

  /**
   * 税率
   */
  @TableField("taxRate")
  private String taxRate;

  /**
   * 税号
   */
  @TableField("taxNo")
  private String taxNo;

  /**
   * 税号公司名称
   */
  @TableField("taxCompanyName")
  private String taxCompanyName;

  /**
   * 结算开始日期
   */
  @TableField("accountingStartDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime accountingStartDate;

  /**
   * 结算结束日期
   */
  @TableField("accountingEndDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime accountingEndDate;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 结算单主号
   */
  @TableField("billNo")
  private String billNo;

  /**
   * B租户代码
   */
  @TableField("bTenantCode")
  private String bTenantCode;

  /**
   * B租户id
   */
  @TableField("bTenantId")
  private Long bTenantId;

  /**
   * 税号开通时间
   */
  @TableField("taxBillingDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime taxBillingDate;

  /**
   * 状态
   */
  private String status;

  /**
   * 本期优惠金额(含税)
   */
  @TableField("discountAmount")
  private BigDecimal discountAmount;

  /**
   * 本期优惠折抵后应结算金额（含税）
   */
  @TableField("currentPayableAmountWithTaxAfterDiscount")
  private BigDecimal currentPayableAmountWithTaxAfterDiscount;

  /**
   * 本期优惠折抵后应结算金额（不含税）
   */
  @TableField("currentPayableAmountWithoutTaxAfterDiscount")
  private BigDecimal currentPayableAmountWithoutTaxAfterDiscount;

  /**
   * 产品名称
   */
  @TableField("productName")
  private String productName;

  /**
   * 内部处理状态
   */
  @TableField("handleStatus")
  private String handleStatus;

  /**
   * 计费给的合同id-内部
   */
  @TableField("originContractId")
  private String originContractId;

  /**
   * 本期折抵金额（含税）
   */
  @TableField("reducedAmountWithTax")
  private BigDecimal reducedAmountWithTax;

  /**
   * 设备类型
   */
  @TableField("deviceType")
  private String deviceType;

  /**
   * 设备编号
   */
  @TableField("deviceNo")
  private String deviceNo;

  /**
   * 设备开始时间
   */
  @TableField("deviceStartDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime deviceStartDate;

  /**
   * 设备结束时间
   */
  @TableField("deviceEndDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime deviceEndDate;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("billDetailNo", billDetailNo);
      map.put("contractNo", contractNo);
      map.put("productNo", productNo);
      map.put("chargeType", chargeType);
      map.put("paymentMethod", paymentMethod);
      map.put("salePriceWithoutTax", salePriceWithoutTax);
      map.put("unitAmountWithoutTax", unitAmountWithoutTax);
      map.put("currentPayableAmountWithTax", currentPayableAmountWithTax);
      map.put("taxRate", taxRate);
      map.put("taxNo", taxNo);
      map.put("taxCompanyName", taxCompanyName);
      map.put("accountingStartDate", BocpGenUtils.toTimestamp(accountingStartDate));
      map.put("accountingEndDate", BocpGenUtils.toTimestamp(accountingEndDate));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("billNo", billNo);
      map.put("bTenantCode", bTenantCode);
      map.put("bTenantId", bTenantId);
      map.put("taxBillingDate", BocpGenUtils.toTimestamp(taxBillingDate));
      map.put("status", status);
      map.put("discountAmount", discountAmount);
      map.put("currentPayableAmountWithTaxAfterDiscount", currentPayableAmountWithTaxAfterDiscount);
      map.put("currentPayableAmountWithoutTaxAfterDiscount", currentPayableAmountWithoutTaxAfterDiscount);
      map.put("productName", productName);
      map.put("handleStatus", handleStatus);
      map.put("originContractId", originContractId);
      map.put("reducedAmountWithTax", reducedAmountWithTax);
      map.put("deviceType", deviceType);
      map.put("deviceNo", deviceNo);
      map.put("deviceStartDate", BocpGenUtils.toTimestamp(deviceStartDate));
      map.put("deviceEndDate", BocpGenUtils.toTimestamp(deviceEndDate));
      return map;
  }

  public static BillDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    BillDetail entity = new BillDetail();
    if(map.containsKey("billDetailNo")) {
      Object obj = map.get("billDetailNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillDetailNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productNo")) {
      Object obj = map.get("productNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeType")) {
      Object obj = map.get("chargeType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentMethod")) {
      Object obj = map.get("paymentMethod");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salePriceWithoutTax")) {
      Object obj = map.get("salePriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSalePriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSalePriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSalePriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setSalePriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSalePriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unitAmountWithoutTax")) {
      Object obj = map.get("unitAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setUnitAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("currentPayableAmountWithTax")) {
      Object obj = map.get("currentPayableAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCurrentPayableAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCurrentPayableAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCurrentPayableAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCurrentPayableAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCurrentPayableAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxNo")) {
      Object obj = map.get("taxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxCompanyName")) {
      Object obj = map.get("taxCompanyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountingStartDate")) {
      Object obj = map.get("accountingStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountingStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAccountingStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAccountingStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAccountingStartDate(null);
      }
    }
    if(map.containsKey("accountingEndDate")) {
      Object obj = map.get("accountingEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountingEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAccountingEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAccountingEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAccountingEndDate(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billNo")) {
      Object obj = map.get("billNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bTenantCode")) {
      Object obj = map.get("bTenantCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bTenantId")) {
      Object obj = map.get("bTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setBTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setBTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("taxBillingDate")) {
      Object obj = map.get("taxBillingDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTaxBillingDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setTaxBillingDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setTaxBillingDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTaxBillingDate(null);
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discountAmount")) {
      Object obj = map.get("discountAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setDiscountAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("currentPayableAmountWithTaxAfterDiscount")) {
      Object obj = map.get("currentPayableAmountWithTaxAfterDiscount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCurrentPayableAmountWithTaxAfterDiscount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCurrentPayableAmountWithTaxAfterDiscount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCurrentPayableAmountWithTaxAfterDiscount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCurrentPayableAmountWithTaxAfterDiscount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCurrentPayableAmountWithTaxAfterDiscount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("currentPayableAmountWithoutTaxAfterDiscount")) {
      Object obj = map.get("currentPayableAmountWithoutTaxAfterDiscount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCurrentPayableAmountWithoutTaxAfterDiscount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCurrentPayableAmountWithoutTaxAfterDiscount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCurrentPayableAmountWithoutTaxAfterDiscount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCurrentPayableAmountWithoutTaxAfterDiscount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCurrentPayableAmountWithoutTaxAfterDiscount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("handleStatus")) {
      Object obj = map.get("handleStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setHandleStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originContractId")) {
      Object obj = map.get("originContractId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginContractId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reducedAmountWithTax")) {
      Object obj = map.get("reducedAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReducedAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReducedAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReducedAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setReducedAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReducedAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("deviceType")) {
      Object obj = map.get("deviceType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeviceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deviceNo")) {
      Object obj = map.get("deviceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeviceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deviceStartDate")) {
      Object obj = map.get("deviceStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDeviceStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setDeviceStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setDeviceStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDeviceStartDate(null);
      }
    }
    if(map.containsKey("deviceEndDate")) {
      Object obj = map.get("deviceEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDeviceEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setDeviceEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setDeviceEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDeviceEndDate(null);
      }
    }
    return entity;
  }
}
