package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialApplyBasicBill;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-08-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class FinancialPurchaseBill extends FinancialApplyBasicBill {


  /**
   * 采购用途
   */
  @TableField("procurementPurposes")
  private String procurementPurposes;

  /**
   * 采购类别编码
   */
  @TableField("procurementTypeCode")
  private String procurementTypeCode;

  /**
   * 采购类别名称
   */
  @TableField("procurementTypeName")
  private String procurementTypeName;

  /**
   * 采购目的编码
   */
  @TableField("procurementPurposesCode")
  private String procurementPurposesCode;

  /**
   * 采购目的名称
   */
  @TableField("procurementPurposesName")
  private String procurementPurposesName;

  /**
   * 项目文本
   */
  @TableField("projectTxt")
  private String projectTxt;

  /**
   * 采购事由
   */
  @TableField("procurementCause")
  private String procurementCause;

  /**
   * 项目档案编码
   */
  @TableField("projectArchivesCode")
  private String projectArchivesCode;

  /**
   * 项目档案名称
   */
  @TableField("projectArchivesName")
  private String projectArchivesName;

  /**
   * 一级部门
   */
  @TableField("oneDepr")
  private String oneDepr;

  /**
   * 所属公司编码
   */
  @TableField("companyCode")
  private String companyCode;

  /**
   * 所属公司名称
   */
  @TableField("companyName")
  private String companyName;

  /**
   * 采购方式编码
   */
  @TableField("procurementWayCode")
  private String procurementWayCode;

  /**
   * 采购方式名称
   */
  @TableField("procurementWayName")
  private String procurementWayName;

  /**
   * 项目所属区域名称
   */
  @TableField("projectAreaName")
  private String projectAreaName;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("procurementPurposes", procurementPurposes);
      map.put("procurementTypeCode", procurementTypeCode);
      map.put("procurementTypeName", procurementTypeName);
      map.put("procurementPurposesCode", procurementPurposesCode);
      map.put("procurementPurposesName", procurementPurposesName);
      map.put("projectTxt", projectTxt);
      map.put("procurementCause", procurementCause);
      map.put("projectArchivesCode", projectArchivesCode);
      map.put("projectArchivesName", projectArchivesName);
      map.put("oneDepr", oneDepr);
      map.put("companyCode", companyCode);
      map.put("companyName", companyName);
      map.put("procurementWayCode", procurementWayCode);
      map.put("procurementWayName", procurementWayName);
      map.put("projectAreaName", projectAreaName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static FinancialPurchaseBill fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    FinancialPurchaseBill entity = new FinancialPurchaseBill();
    if(map.containsKey("applicationDate")) {
      Object obj = map.get("applicationDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApplicationDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setApplicationDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setApplicationDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setApplicationDate(null);
      }
    }
    if(map.containsKey("applicantDept")) {
      Object obj = map.get("applicantDept");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplicantDept((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applicantCompanyCode")) {
      Object obj = map.get("applicantCompanyCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplicantCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applicantCompanyName")) {
      Object obj = map.get("applicantCompanyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplicantCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("procurementPurposes")) {
      Object obj = map.get("procurementPurposes");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcurementPurposes((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementTypeCode")) {
      Object obj = map.get("procurementTypeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcurementTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementTypeName")) {
      Object obj = map.get("procurementTypeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcurementTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementPurposesCode")) {
      Object obj = map.get("procurementPurposesCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcurementPurposesCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementPurposesName")) {
      Object obj = map.get("procurementPurposesName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcurementPurposesName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectTxt")) {
      Object obj = map.get("projectTxt");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectTxt((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementCause")) {
      Object obj = map.get("procurementCause");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcurementCause((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectArchivesCode")) {
      Object obj = map.get("projectArchivesCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectArchivesCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectArchivesName")) {
      Object obj = map.get("projectArchivesName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectArchivesName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oneDepr")) {
      Object obj = map.get("oneDepr");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOneDepr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyCode")) {
      Object obj = map.get("companyCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementWayCode")) {
      Object obj = map.get("procurementWayCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcurementWayCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementWayName")) {
      Object obj = map.get("procurementWayName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcurementWayName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectAreaName")) {
      Object obj = map.get("projectAreaName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectAreaName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
