package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-09-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BillStaticsDetail implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 对账单明细单号
   */
  @TableField("billDetailNo")
  private String billDetailNo;

  /**
   * 合同号
   */
  @TableField("contractNo")
  private String contractNo;

  /**
   * 产品编号
   */
  @TableField("productNo")
  private String productNo;

  /**
   * 计费类型
   */
  @TableField("chargeType")
  private String chargeType;

  /**
   * 售价（不含税）
   */
  @TableField("salePriceWithoutTax")
  private String salePriceWithoutTax;

  /**
   * 单价（不含税）
   */
  @TableField("unitAmountWithoutTax")
  private String unitAmountWithoutTax;

  /**
   * 本期应结算金额（含税）
   */
  @TableField("currentPayableAmountWithTax")
  private String currentPayableAmountWithTax;

  /**
   * 税率
   */
  @TableField("taxRate")
  private String taxRate;

  /**
   * 使用公司税号
   */
  @TableField("taxNo")
  private String taxNo;

  /**
   * 使用公司名称
   */
  @TableField("taxCompanyName")
  private String taxCompanyName;

  /**
   * 结算开始日期
   */
  @TableField("accountingStartDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime accountingStartDate;

  /**
   * 结算结束日期
   */
  @TableField("accountingEndDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime accountingEndDate;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 发票代码
   */
  @TableField("invoiceCode")
  private String invoiceCode;

  /**
   * 发票号码
   */
  @TableField("invoiceNo")
  private String invoiceNo;

  /**
   * 待核销金额--作废
   */
  @TableField("waitingAmount")
  private BigDecimal waitingAmount;

  /**
   * 已核销金额--作废
   */
  @TableField("readyAmount")
  private BigDecimal readyAmount;

  /**
   * 订单号
   */
  @TableField("orderNo")
  private String orderNo;

  /**
   * 付费类型
   */
  @TableField("paymentType")
  private String paymentType;

  /**
   * 付款条件
   */
  @TableField("paymentRequirement")
  private String paymentRequirement;

  /**
   * 性质
   */
  private String property;

  /**
   * 数量
   */
  private BigDecimal quantity;

  /**
   * 计价单位
   */
  @TableField("chargeUnit")
  private String chargeUnit;

  /**
   * 计费天数
   */
  @TableField("chargeDays")
  private Long chargeDays;

  /**
   * 结算周期
   */
  @TableField("chargeCycle")
  private String chargeCycle;

  /**
   * 对账单创建日期
   */
  @TableField("billCreateDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime billCreateDate;

  /**
   * 发票抬头公司名称
   */
  @TableField("invoiceCompanyName")
  private String invoiceCompanyName;

  /**
   * 发票抬头公司税号
   */
  @TableField("invoiceCompanyTaxNo")
  private String invoiceCompanyTaxNo;

  /**
   * 开票日期
   */
  @TableField("invoiceGenerateDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime invoiceGenerateDate;

  /**
   * 开票金额（不含税）
   */
  @TableField("invoiceAmountWithoutTax")
  private BigDecimal invoiceAmountWithoutTax;

  /**
   * 开票金额（含税）
   */
  @TableField("invoiceAmountWithTax")
  private BigDecimal invoiceAmountWithTax;

  /**
   * 付款公司
   */
  @TableField("paymentCompany")
  private String paymentCompany;

  /**
   * 本期优惠金额（含税）
   */
  @TableField("currentDiscountAmountWithTax")
  private BigDecimal currentDiscountAmountWithTax;

  /**
   * 回款日期
   */
  @TableField("payBackDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime payBackDate;

  /**
   * 回款金额
   */
  @TableField("payBackAmount")
  private BigDecimal payBackAmount;

  /**
   * 数据类型
   */
  @TableField("dataType")
  private String dataType;

  /**
   * 要核销余额-作废
   */
  @TableField("compensateAmount")
  private BigDecimal compensateAmount;

  /**
   * 本期优惠后应结算金额（含税）
   */
  @TableField("currentPayableAmountAfterDiscountWithTax")
  private BigDecimal currentPayableAmountAfterDiscountWithTax;

  /**
   * 本期优惠后应结算金额（不含税）
   */
  @TableField("currentPayableAmountAfterDiscountWithoutTax")
  private BigDecimal currentPayableAmountAfterDiscountWithoutTax;

  /**
   * 订单总金额
   */
  @TableField("orderTotalAmount")
  private BigDecimal orderTotalAmount;

  /**
   * 订单待核销金额
   */
  @TableField("orderWaitAmount")
  private BigDecimal orderWaitAmount;

  /**
   * 订单已核销金额
   */
  @TableField("orderReadyAmount")
  private BigDecimal orderReadyAmount;

  /**
   * 发票待核销金额
   */
  @TableField("invoiceWaitAmount")
  private BigDecimal invoiceWaitAmount;

  /**
   * 发票已核销金额
   */
  @TableField("invoiceReadyAmount")
  private BigDecimal invoiceReadyAmount;

  /**
   * 税号待核销金额
   */
  @TableField("taxWaitAmount")
  private BigDecimal taxWaitAmount;

  /**
   * 税号已核销金额
   */
  @TableField("taxReadyAmount")
  private BigDecimal taxReadyAmount;

  /**
   * 是否展示
   */
  @TableField("isShow")
  private Boolean isShow;

  /**
   * 流水索引
   */
  @TableField("indexTradeNo")
  private String indexTradeNo;

  /**
   * 流水分摊信息
   */
  @TableField("tradeShareInfo")
  private String tradeShareInfo;

  /**
   * 订单生成日期
   */
  @TableField("orderGenerateDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime orderGenerateDate;

  /**
   * 结算对账单编号
   */
  @TableField("billNo")
  private String billNo;

  /**
   * 产品服务名称
   */
  @TableField("productName")
  private String productName;

  /**
   * 本期折抵金额(含税)
   */
  @TableField("reducedAmountWithTax")
  private BigDecimal reducedAmountWithTax;

  /**
   * 设备编号
   */
  @TableField("deviceNo")
  private String deviceNo;

  /**
   * 设备类型
   */
  @TableField("deviceType")
  private String deviceType;

  /**
   * 是否有效
   */
  @TableField("whetherEffectiveOrNot")
  private String whetherEffectiveOrNot;

  /**
   * 验收时间
   */
  @TableField("acceptanceTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime acceptanceTime;

  /**
   * 项目分期名称
   */
  @TableField("projectItemName")
  private String projectItemName;

  /**
   * 项目分期编号
   */
  @TableField("projectItemCode")
  private String projectItemCode;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("billDetailNo", billDetailNo);
      map.put("contractNo", contractNo);
      map.put("productNo", productNo);
      map.put("chargeType", chargeType);
      map.put("salePriceWithoutTax", salePriceWithoutTax);
      map.put("unitAmountWithoutTax", unitAmountWithoutTax);
      map.put("currentPayableAmountWithTax", currentPayableAmountWithTax);
      map.put("taxRate", taxRate);
      map.put("taxNo", taxNo);
      map.put("taxCompanyName", taxCompanyName);
      map.put("accountingStartDate", BocpGenUtils.toTimestamp(accountingStartDate));
      map.put("accountingEndDate", BocpGenUtils.toTimestamp(accountingEndDate));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("invoiceCode", invoiceCode);
      map.put("invoiceNo", invoiceNo);
      map.put("waitingAmount", waitingAmount);
      map.put("readyAmount", readyAmount);
      map.put("orderNo", orderNo);
      map.put("paymentType", paymentType);
      map.put("paymentRequirement", paymentRequirement);
      map.put("property", property);
      map.put("quantity", quantity);
      map.put("chargeUnit", chargeUnit);
      map.put("chargeDays", chargeDays);
      map.put("chargeCycle", chargeCycle);
      map.put("billCreateDate", BocpGenUtils.toTimestamp(billCreateDate));
      map.put("invoiceCompanyName", invoiceCompanyName);
      map.put("invoiceCompanyTaxNo", invoiceCompanyTaxNo);
      map.put("invoiceGenerateDate", BocpGenUtils.toTimestamp(invoiceGenerateDate));
      map.put("invoiceAmountWithoutTax", invoiceAmountWithoutTax);
      map.put("invoiceAmountWithTax", invoiceAmountWithTax);
      map.put("paymentCompany", paymentCompany);
      map.put("currentDiscountAmountWithTax", currentDiscountAmountWithTax);
      map.put("payBackDate", BocpGenUtils.toTimestamp(payBackDate));
      map.put("payBackAmount", payBackAmount);
      map.put("dataType", dataType);
      map.put("compensateAmount", compensateAmount);
      map.put("currentPayableAmountAfterDiscountWithTax", currentPayableAmountAfterDiscountWithTax);
      map.put("currentPayableAmountAfterDiscountWithoutTax", currentPayableAmountAfterDiscountWithoutTax);
      map.put("orderTotalAmount", orderTotalAmount);
      map.put("orderWaitAmount", orderWaitAmount);
      map.put("orderReadyAmount", orderReadyAmount);
      map.put("invoiceWaitAmount", invoiceWaitAmount);
      map.put("invoiceReadyAmount", invoiceReadyAmount);
      map.put("taxWaitAmount", taxWaitAmount);
      map.put("taxReadyAmount", taxReadyAmount);
      map.put("isShow", isShow);
      map.put("indexTradeNo", indexTradeNo);
      map.put("tradeShareInfo", tradeShareInfo);
      map.put("orderGenerateDate", BocpGenUtils.toTimestamp(orderGenerateDate));
      map.put("billNo", billNo);
      map.put("productName", productName);
      map.put("reducedAmountWithTax", reducedAmountWithTax);
      map.put("deviceNo", deviceNo);
      map.put("deviceType", deviceType);
      map.put("whetherEffectiveOrNot", whetherEffectiveOrNot);
      map.put("acceptanceTime", BocpGenUtils.toTimestamp(acceptanceTime));
      map.put("projectItemName", projectItemName);
      map.put("projectItemCode", projectItemCode);
      return map;
  }

  public static BillStaticsDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    BillStaticsDetail entity = new BillStaticsDetail();
    if(map.containsKey("billDetailNo")) {
      Object obj = map.get("billDetailNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillDetailNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productNo")) {
      Object obj = map.get("productNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeType")) {
      Object obj = map.get("chargeType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salePriceWithoutTax")) {
      Object obj = map.get("salePriceWithoutTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalePriceWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unitAmountWithoutTax")) {
      Object obj = map.get("unitAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUnitAmountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currentPayableAmountWithTax")) {
      Object obj = map.get("currentPayableAmountWithTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurrentPayableAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxNo")) {
      Object obj = map.get("taxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxCompanyName")) {
      Object obj = map.get("taxCompanyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountingStartDate")) {
      Object obj = map.get("accountingStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountingStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAccountingStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAccountingStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAccountingStartDate(null);
      }
    }
    if(map.containsKey("accountingEndDate")) {
      Object obj = map.get("accountingEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountingEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAccountingEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAccountingEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAccountingEndDate(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("waitingAmount")) {
      Object obj = map.get("waitingAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setWaitingAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setWaitingAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setWaitingAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setWaitingAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setWaitingAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("readyAmount")) {
      Object obj = map.get("readyAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReadyAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReadyAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReadyAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setReadyAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReadyAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("orderNo")) {
      Object obj = map.get("orderNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentType")) {
      Object obj = map.get("paymentType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentRequirement")) {
      Object obj = map.get("paymentRequirement");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentRequirement((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("property")) {
      Object obj = map.get("property");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProperty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("chargeUnit")) {
      Object obj = map.get("chargeUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeDays")) {
      Object obj = map.get("chargeDays");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChargeDays((Long)obj);
        } else if(obj instanceof String) {
          entity.setChargeDays(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setChargeDays(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("chargeCycle")) {
      Object obj = map.get("chargeCycle");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeCycle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billCreateDate")) {
      Object obj = map.get("billCreateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBillCreateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setBillCreateDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setBillCreateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBillCreateDate(null);
      }
    }
    if(map.containsKey("invoiceCompanyName")) {
      Object obj = map.get("invoiceCompanyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCompanyTaxNo")) {
      Object obj = map.get("invoiceCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceGenerateDate")) {
      Object obj = map.get("invoiceGenerateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceGenerateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setInvoiceGenerateDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setInvoiceGenerateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setInvoiceGenerateDate(null);
      }
    }
    if(map.containsKey("invoiceAmountWithoutTax")) {
      Object obj = map.get("invoiceAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setInvoiceAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAmountWithTax")) {
      Object obj = map.get("invoiceAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setInvoiceAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("paymentCompany")) {
      Object obj = map.get("paymentCompany");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentCompany((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currentDiscountAmountWithTax")) {
      Object obj = map.get("currentDiscountAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCurrentDiscountAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCurrentDiscountAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCurrentDiscountAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCurrentDiscountAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCurrentDiscountAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("payBackDate")) {
      Object obj = map.get("payBackDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPayBackDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPayBackDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPayBackDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPayBackDate(null);
      }
    }
    if(map.containsKey("payBackAmount")) {
      Object obj = map.get("payBackAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPayBackAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPayBackAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPayBackAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPayBackAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayBackAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("dataType")) {
      Object obj = map.get("dataType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDataType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("compensateAmount")) {
      Object obj = map.get("compensateAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCompensateAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCompensateAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCompensateAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCompensateAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCompensateAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("currentPayableAmountAfterDiscountWithTax")) {
      Object obj = map.get("currentPayableAmountAfterDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCurrentPayableAmountAfterDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCurrentPayableAmountAfterDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCurrentPayableAmountAfterDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCurrentPayableAmountAfterDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCurrentPayableAmountAfterDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("currentPayableAmountAfterDiscountWithoutTax")) {
      Object obj = map.get("currentPayableAmountAfterDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCurrentPayableAmountAfterDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCurrentPayableAmountAfterDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCurrentPayableAmountAfterDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCurrentPayableAmountAfterDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCurrentPayableAmountAfterDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("orderTotalAmount")) {
      Object obj = map.get("orderTotalAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOrderTotalAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOrderTotalAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOrderTotalAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setOrderTotalAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderTotalAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("orderWaitAmount")) {
      Object obj = map.get("orderWaitAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOrderWaitAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOrderWaitAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOrderWaitAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setOrderWaitAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderWaitAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("orderReadyAmount")) {
      Object obj = map.get("orderReadyAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOrderReadyAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOrderReadyAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOrderReadyAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setOrderReadyAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderReadyAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceWaitAmount")) {
      Object obj = map.get("invoiceWaitAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceWaitAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceWaitAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceWaitAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setInvoiceWaitAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceWaitAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceReadyAmount")) {
      Object obj = map.get("invoiceReadyAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceReadyAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceReadyAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceReadyAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setInvoiceReadyAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceReadyAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxWaitAmount")) {
      Object obj = map.get("taxWaitAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxWaitAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxWaitAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxWaitAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxWaitAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxWaitAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxReadyAmount")) {
      Object obj = map.get("taxReadyAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxReadyAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxReadyAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxReadyAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxReadyAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxReadyAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("isShow")) {
      Object obj = map.get("isShow");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsShow((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setIsShow(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("indexTradeNo")) {
      Object obj = map.get("indexTradeNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIndexTradeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tradeShareInfo")) {
      Object obj = map.get("tradeShareInfo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTradeShareInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderGenerateDate")) {
      Object obj = map.get("orderGenerateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderGenerateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setOrderGenerateDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setOrderGenerateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOrderGenerateDate(null);
      }
    }
    if(map.containsKey("billNo")) {
      Object obj = map.get("billNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reducedAmountWithTax")) {
      Object obj = map.get("reducedAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReducedAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReducedAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReducedAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setReducedAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReducedAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("deviceNo")) {
      Object obj = map.get("deviceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeviceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deviceType")) {
      Object obj = map.get("deviceType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeviceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("whetherEffectiveOrNot")) {
      Object obj = map.get("whetherEffectiveOrNot");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWhetherEffectiveOrNot((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("acceptanceTime")) {
      Object obj = map.get("acceptanceTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAcceptanceTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAcceptanceTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAcceptanceTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAcceptanceTime(null);
      }
    }
    if(map.containsKey("projectItemName")) {
      Object obj = map.get("projectItemName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectItemCode")) {
      Object obj = map.get("projectItemCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectItemCode((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
