package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialBasicBillDetail;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-09-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class FinancialHesWriteoffBillDetail extends FinancialBasicBillDetail {


  /**
   * 同行人编码
   */
  @TableField("applicantNumber")
  private String applicantNumber;

  /**
   * 同行人名称
   */
  @TableField("applicantName")
  private String applicantName;

  /**
   * 订单金额
   */
  @TableField("orderAmount")
  private String orderAmount;

  /**
   * 消费开始日期
   */
  @TableField("consumptionStartDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime consumptionStartDate;

  /**
   * 消费结束日期
   */
  @TableField("consumptionEndDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime consumptionEndDate;

  /**
   * 是否分摊
   */
  @TableField("ifApportion")
  private String ifApportion;

  /**
   * 发票形式
   */
  @TableField("invoiceForm")
  private String invoiceForm;

  /**
   * 结算方式
   */
  @TableField("clearingForm")
  private String clearingForm;

  /**
   * 税额
   */
  @TableField("invoiceTax")
  private String invoiceTax;

  /**
   * 发票号码
   */
  @TableField("invoiceNumber")
  private String invoiceNumber;

  /**
   * 登机牌
   */
  @TableField("invoiceQuantity")
  private String invoiceQuantity;

  /**
   * 消费城市
   */
  @TableField("costCity")
  private String costCity;

  /**
   * 分摊项目编码
   */
  @TableField("apportionProjectCode")
  private String apportionProjectCode;

  /**
   * 分摊项目名称
   */
  @TableField("apportionProjectName")
  private String apportionProjectName;

  /**
   * 分摊比例
   */
  @TableField("apportionRatio")
  private String apportionRatio;

  /**
   * 分摊金额
   */
  @TableField("apportionAmount")
  private String apportionAmount;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("applicantNumber", applicantNumber);
      map.put("applicantName", applicantName);
      map.put("orderAmount", orderAmount);
      map.put("consumptionStartDate", BocpGenUtils.toTimestamp(consumptionStartDate));
      map.put("consumptionEndDate", BocpGenUtils.toTimestamp(consumptionEndDate));
      map.put("ifApportion", ifApportion);
      map.put("invoiceForm", invoiceForm);
      map.put("clearingForm", clearingForm);
      map.put("invoiceTax", invoiceTax);
      map.put("invoiceNumber", invoiceNumber);
      map.put("invoiceQuantity", invoiceQuantity);
      map.put("costCity", costCity);
      map.put("apportionProjectCode", apportionProjectCode);
      map.put("apportionProjectName", apportionProjectName);
      map.put("apportionRatio", apportionRatio);
      map.put("apportionAmount", apportionAmount);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static FinancialHesWriteoffBillDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    FinancialHesWriteoffBillDetail entity = new FinancialHesWriteoffBillDetail();
    if(map.containsKey("primaryCostTypeCode")) {
      Object obj = map.get("primaryCostTypeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrimaryCostTypeCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("primaryCostTypeName")) {
      Object obj = map.get("primaryCostTypeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrimaryCostTypeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("lastCostTypeCode")) {
      Object obj = map.get("lastCostTypeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLastCostTypeCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("lastCostTypeName")) {
      Object obj = map.get("lastCostTypeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLastCostTypeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("origin")) {
      Object obj = map.get("origin");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrigin((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("destination")) {
      Object obj = map.get("destination");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDestination((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tripExplain")) {
      Object obj = map.get("tripExplain");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTripExplain((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("costDate")) {
      Object obj = map.get("costDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCostDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCostDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCostDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setCostDate(null);
      }
    }
    if(map.containsKey("billTemplateDetail")) {
      Object obj = map.get("billTemplateDetail");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillTemplateDetail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applicantNumber")) {
      Object obj = map.get("applicantNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplicantNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applicantName")) {
      Object obj = map.get("applicantName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplicantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderAmount")) {
      Object obj = map.get("orderAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("consumptionStartDate")) {
      Object obj = map.get("consumptionStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setConsumptionStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setConsumptionStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setConsumptionStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setConsumptionStartDate(null);
      }
    }
    if(map.containsKey("consumptionEndDate")) {
      Object obj = map.get("consumptionEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setConsumptionEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setConsumptionEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setConsumptionEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setConsumptionEndDate(null);
      }
    }
    if(map.containsKey("ifApportion")) {
      Object obj = map.get("ifApportion");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIfApportion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceForm")) {
      Object obj = map.get("invoiceForm");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceForm((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("clearingForm")) {
      Object obj = map.get("clearingForm");
      if(obj != null) {
        if(obj instanceof String){
          entity.setClearingForm((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceTax")) {
      Object obj = map.get("invoiceTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNumber")) {
      Object obj = map.get("invoiceNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceQuantity")) {
      Object obj = map.get("invoiceQuantity");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceQuantity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("costCity")) {
      Object obj = map.get("costCity");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostCity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("apportionProjectCode")) {
      Object obj = map.get("apportionProjectCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApportionProjectCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("apportionProjectName")) {
      Object obj = map.get("apportionProjectName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApportionProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("apportionRatio")) {
      Object obj = map.get("apportionRatio");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApportionRatio((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("apportionAmount")) {
      Object obj = map.get("apportionAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApportionAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
