package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-09-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class FkjBillRelation implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 事前单据号
   */
  @TableField("thingBeforeBillNo")
  private String thingBeforeBillNo;

  /**
   * 事前单据主题
   */
  @TableField("thingBeforeSubject")
  private String thingBeforeSubject;

  /**
   * 事前单据申请部门
   */
  @TableField("thingBeforeApplyDepart")
  private String thingBeforeApplyDepart;

  /**
   * 事前单据申请人
   */
  @TableField("thingBeforeApplyUser")
  private String thingBeforeApplyUser;

  /**
   * 事前单据申请日期
   */
  @TableField("thingBeforeApplyDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime thingBeforeApplyDate;

  /**
   * 事前单据申请金额
   */
  @TableField("thingBeforeApplyAmount")
  private BigDecimal thingBeforeApplyAmount;

  /**
   * 已核销金额
   */
  @TableField("readyAmount")
  private BigDecimal readyAmount;

  /**
   * 关联单据编号
   */
  @TableField("relationBillNo")
  private String relationBillNo;

  /**
   * 关联单据主题
   */
  @TableField("relationBillSubject")
  private String relationBillSubject;

  /**
   * 关联单据申请部门
   */
  @TableField("relationApplyDepart")
  private String relationApplyDepart;

  /**
   * 关联单据申请人
   */
  @TableField("relationApplyUser")
  private String relationApplyUser;

  /**
   * 关联单据申请日期
   */
  @TableField("relationApplyDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime relationApplyDate;

  /**
   * 关联单据申请金额
   */
  @TableField("relationApplyAmount")
  private BigDecimal relationApplyAmount;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("thingBeforeBillNo", thingBeforeBillNo);
      map.put("thingBeforeSubject", thingBeforeSubject);
      map.put("thingBeforeApplyDepart", thingBeforeApplyDepart);
      map.put("thingBeforeApplyUser", thingBeforeApplyUser);
      map.put("thingBeforeApplyDate", BocpGenUtils.toTimestamp(thingBeforeApplyDate));
      map.put("thingBeforeApplyAmount", thingBeforeApplyAmount);
      map.put("readyAmount", readyAmount);
      map.put("relationBillNo", relationBillNo);
      map.put("relationBillSubject", relationBillSubject);
      map.put("relationApplyDepart", relationApplyDepart);
      map.put("relationApplyUser", relationApplyUser);
      map.put("relationApplyDate", BocpGenUtils.toTimestamp(relationApplyDate));
      map.put("relationApplyAmount", relationApplyAmount);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static FkjBillRelation fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    FkjBillRelation entity = new FkjBillRelation();
    if(map.containsKey("thingBeforeBillNo")) {
      Object obj = map.get("thingBeforeBillNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setThingBeforeBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("thingBeforeSubject")) {
      Object obj = map.get("thingBeforeSubject");
      if(obj != null) {
        if(obj instanceof String){
          entity.setThingBeforeSubject((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("thingBeforeApplyDepart")) {
      Object obj = map.get("thingBeforeApplyDepart");
      if(obj != null) {
        if(obj instanceof String){
          entity.setThingBeforeApplyDepart((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("thingBeforeApplyUser")) {
      Object obj = map.get("thingBeforeApplyUser");
      if(obj != null) {
        if(obj instanceof String){
          entity.setThingBeforeApplyUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("thingBeforeApplyDate")) {
      Object obj = map.get("thingBeforeApplyDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setThingBeforeApplyDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setThingBeforeApplyDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setThingBeforeApplyDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setThingBeforeApplyDate(null);
      }
    }
    if(map.containsKey("thingBeforeApplyAmount")) {
      Object obj = map.get("thingBeforeApplyAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setThingBeforeApplyAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setThingBeforeApplyAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setThingBeforeApplyAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setThingBeforeApplyAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setThingBeforeApplyAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("readyAmount")) {
      Object obj = map.get("readyAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReadyAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReadyAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReadyAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setReadyAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReadyAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("relationBillNo")) {
      Object obj = map.get("relationBillNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRelationBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("relationBillSubject")) {
      Object obj = map.get("relationBillSubject");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRelationBillSubject((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("relationApplyDepart")) {
      Object obj = map.get("relationApplyDepart");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRelationApplyDepart((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("relationApplyUser")) {
      Object obj = map.get("relationApplyUser");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRelationApplyUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("relationApplyDate")) {
      Object obj = map.get("relationApplyDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRelationApplyDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setRelationApplyDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setRelationApplyDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRelationApplyDate(null);
      }
    }
    if(map.containsKey("relationApplyAmount")) {
      Object obj = map.get("relationApplyAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRelationApplyAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRelationApplyAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRelationApplyAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setRelationApplyAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRelationApplyAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
