package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-09-06
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class FinancialBasicBill implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 申请人编码
   */
  @TableField("applicantNumber")
  private String applicantNumber;

  /**
   * 申请人名称
   */
  @TableField("applicantName")
  private String applicantName;

  /**
   * 出差事由
   */
  @TableField("travelReason")
  private String travelReason;

  /**
   * 成本中心编码
   */
  @TableField("costCenterCode")
  private String costCenterCode;

  /**
   * 成本中心名称
   */
  @TableField("costCenterName")
  private String costCenterName;

  /**
   * 项目所属区域编码
   */
  @TableField("projectAreaCode")
  private String projectAreaCode;

  /**
   * 项目所属区域名称
   */
  @TableField("projectAreaname")
  private String projectAreaname;

  /**
   * KAM编码
   */
  @TableField("kamCode")
  private String kamCode;

  /**
   * KAM名称
   */
  @TableField("kamName")
  private String kamName;

  /**
   * leader编码
   */
  @TableField("leaderCode")
  private String leaderCode;

  /**
   * leader名称
   */
  @TableField("leaderName")
  private String leaderName;

  /**
   * 项目类别编码
   */
  @TableField("projectTypeCode")
  private String projectTypeCode;

  /**
   * 项目类别名称
   */
  @TableField("projectTypeName")
  private String projectTypeName;

  /**
   * Owner编码
   */
  @TableField("ownerCode")
  private String ownerCode;

  /**
   * Owner名称
   */
  @TableField("ownerName")
  private String ownerName;

  /**
   * 项目预算大类编码
   */
  @TableField("projectBudgetTypeCode")
  private String projectBudgetTypeCode;

  /**
   * 项目预算大类名称
   */
  @TableField("projectBudgetTypeName")
  private String projectBudgetTypeName;

  /**
   * 员工邮箱​
   */
  @TableField("staffEmail")
  private String staffEmail;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 单据模板
   */
  @TableField("billTemplate")
  private String billTemplate;

  /**
   * 单据大类
   */
  @TableField("billType")
  private String billType;

  /**
   * 补充
   */
  @TableField("newSupplement")
  private String newSupplement;

  /**
   * 补充申请名称
   */
  @TableField("supplementaryApplicationName")
  private String supplementaryApplicationName;

  /**
   * 补充申请编码
   */
  @TableField("supplementaryApplicationCode")
  private String supplementaryApplicationCode;

  /**
   * 单据模板Code
   */
  @TableField("billTemplateType")
  private String billTemplateType;

  /**
   * 单据编号
   */
  @TableField("billsNumber")
  private String billsNumber;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("applicantNumber", applicantNumber);
      map.put("applicantName", applicantName);
      map.put("travelReason", travelReason);
      map.put("costCenterCode", costCenterCode);
      map.put("costCenterName", costCenterName);
      map.put("projectAreaCode", projectAreaCode);
      map.put("projectAreaname", projectAreaname);
      map.put("kamCode", kamCode);
      map.put("kamName", kamName);
      map.put("leaderCode", leaderCode);
      map.put("leaderName", leaderName);
      map.put("projectTypeCode", projectTypeCode);
      map.put("projectTypeName", projectTypeName);
      map.put("ownerCode", ownerCode);
      map.put("ownerName", ownerName);
      map.put("projectBudgetTypeCode", projectBudgetTypeCode);
      map.put("projectBudgetTypeName", projectBudgetTypeName);
      map.put("staffEmail", staffEmail);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("billTemplate", billTemplate);
      map.put("billType", billType);
      map.put("newSupplement", newSupplement);
      map.put("supplementaryApplicationName", supplementaryApplicationName);
      map.put("supplementaryApplicationCode", supplementaryApplicationCode);
      map.put("billTemplateType", billTemplateType);
      map.put("billsNumber", billsNumber);
      return map;
  }

  public static FinancialBasicBill fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    FinancialBasicBill entity = new FinancialBasicBill();
    if(map.containsKey("applicantNumber")) {
      Object obj = map.get("applicantNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplicantNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applicantName")) {
      Object obj = map.get("applicantName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplicantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("travelReason")) {
      Object obj = map.get("travelReason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTravelReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("costCenterCode")) {
      Object obj = map.get("costCenterCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostCenterCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("costCenterName")) {
      Object obj = map.get("costCenterName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostCenterName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectAreaCode")) {
      Object obj = map.get("projectAreaCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectAreaCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectAreaname")) {
      Object obj = map.get("projectAreaname");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectAreaname((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("kamCode")) {
      Object obj = map.get("kamCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setKamCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("kamName")) {
      Object obj = map.get("kamName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setKamName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("leaderCode")) {
      Object obj = map.get("leaderCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLeaderCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("leaderName")) {
      Object obj = map.get("leaderName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLeaderName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectTypeCode")) {
      Object obj = map.get("projectTypeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectTypeName")) {
      Object obj = map.get("projectTypeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ownerCode")) {
      Object obj = map.get("ownerCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOwnerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ownerName")) {
      Object obj = map.get("ownerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOwnerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectBudgetTypeCode")) {
      Object obj = map.get("projectBudgetTypeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectBudgetTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectBudgetTypeName")) {
      Object obj = map.get("projectBudgetTypeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectBudgetTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("staffEmail")) {
      Object obj = map.get("staffEmail");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStaffEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billTemplate")) {
      Object obj = map.get("billTemplate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillTemplate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billType")) {
      Object obj = map.get("billType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("newSupplement")) {
      Object obj = map.get("newSupplement");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNewSupplement((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplementaryApplicationName")) {
      Object obj = map.get("supplementaryApplicationName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSupplementaryApplicationName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplementaryApplicationCode")) {
      Object obj = map.get("supplementaryApplicationCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSupplementaryApplicationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billTemplateType")) {
      Object obj = map.get("billTemplateType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillTemplateType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billsNumber")) {
      Object obj = map.get("billsNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillsNumber((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
