package com.xforceplus.ultraman.app.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 源数据枚举定义
 * </p>
 *
 * @author ultraman
 * @since 2022-09-29
 */
public enum SourceMateDataEnum {

    ORDER_INFO("orderInfo", "订单数据"),
    CONTRACT("contract", "合同"),
    BILL("bill", "结算对账单"),
    BILL_DETAIL("billDetail", "结算单用量"),
    BILL_DETAIL_MONTH("billDetailMonth", "结算单用量月汇总"),
    MONTH_FLOW("monthFlow", "月流水"),
    INVOICE("invoice", "发票主数据"),
    ORDER_INVOICE("orderInvoice", "订单发票关系"),
    ORDER_TAX_NO("orderTaxNo", "订单税号关系"),
    ORDER_BILL("orderBill", "订单结算单关系"),
    TAX_NO_SERVICE("taxNoService", "税号服务开通履历"),
    ORDER_RECEPTION("orderReception", "订单验收履历"),
    PROJECT_ITEM("projectItem", "项目分期"),
    ORDER_PROJECT_ITEM_BIND("orderProjectItemBind", "订单绑定项目分期"),
    SMALL_ORDER("smallOrder", "小B订单"),
    SMALL_ORDER_INVOICE("smallOrderInvoice", "小B订单发票关系"),
    BS_DEPARTMENT_COST("bsDepartmentCost", "北森部门实际月成本"),
    BS_MEMBER_COST("bsMemberCost", "北森员工标准月成本"),
    BS_MEMBER_ROLE_COST("bsMemberRoleCost", "北森员工角色标准成本"),
    NB_BANK_TRADE_DETAIL("nbBankTradeDetail", "宁波银行交易流水"),
    BASIS("basis", "chargeCode基础数据"),
    BUDGET("budget", "chargeCode预算数据");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SourceMateDataEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SourceMateDataEnum fromCode(String code){
        switch(code) {
            case "orderInfo":
                return ORDER_INFO;
            case "contract":
                return CONTRACT;
            case "bill":
                return BILL;
            case "billDetail":
                return BILL_DETAIL;
            case "billDetailMonth":
                return BILL_DETAIL_MONTH;
            case "monthFlow":
                return MONTH_FLOW;
            case "invoice":
                return INVOICE;
            case "orderInvoice":
                return ORDER_INVOICE;
            case "orderTaxNo":
                return ORDER_TAX_NO;
            case "orderBill":
                return ORDER_BILL;
            case "taxNoService":
                return TAX_NO_SERVICE;
            case "orderReception":
                return ORDER_RECEPTION;
            case "projectItem":
                return PROJECT_ITEM;
            case "orderProjectItemBind":
                return ORDER_PROJECT_ITEM_BIND;
            case "smallOrder":
                return SMALL_ORDER;
            case "smallOrderInvoice":
                return SMALL_ORDER_INVOICE;
            case "bsDepartmentCost":
                return BS_DEPARTMENT_COST;
            case "bsMemberCost":
                return BS_MEMBER_COST;
            case "bsMemberRoleCost":
                return BS_MEMBER_ROLE_COST;
            case "nbBankTradeDetail":
                return NB_BANK_TRADE_DETAIL;
            case "basis":
                return BASIS;
            case "budget":
                return BUDGET;
            default:
                return null;
        }
    }
}
