package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-09-29
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class FinancialBasicBillDetail implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 一级费用类型编码 
   */
  @TableField("primaryCostTypeCode")
  private String primaryCostTypeCode;

  /**
   * 一级费用类型名称
   */
  @TableField("primaryCostTypeName")
  private String primaryCostTypeName;

  /**
   * 末级费用类型编码
   */
  @TableField("lastCostTypeCode")
  private String lastCostTypeCode;

  /**
   * 末级费用类型名称
   */
  @TableField("lastCostTypeName")
  private String lastCostTypeName;

  /**
   * 起点
   */
  private String origin;

  /**
   * 终点
   */
  private String destination;

  /**
   * 金额
   */
  private String amount;

  /**
   * 行程说明
   */
  @TableField("tripExplain")
  private String tripExplain;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 费用日期
   */
  @TableField("costDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime costDate;

  /**
   * 单据模本明细
   */
  @TableField("billTemplateDetail")
  private String billTemplateDetail;

  /**
   *  二级费用类型编码
   */
  @TableField("twoCostTypeCode")
  private String twoCostTypeCode;

  /**
   *  二级费用类型名称
   */
  @TableField("twoCostTypeName")
  private String twoCostTypeName;

  /**
   *  三级费用类型编码
   */
  @TableField("threeCostTypeCode")
  private String threeCostTypeCode;

  /**
   *  三级费用类型名称
   */
  @TableField("threeCostTypeName")
  private String threeCostTypeName;

  /**
   *  四级费用类型编码
   */
  @TableField("fourCostTypeCode")
  private String fourCostTypeCode;

  /**
   *  四级费用类型名称
   */
  @TableField("fourCostTypeName")
  private String fourCostTypeName;

  /**
   *  五级费用类型编码
   */
  @TableField("fiveCostTypeCode")
  private String fiveCostTypeCode;

  /**
   *  五级费用类型名称
   */
  @TableField("fiveCostTypeName")
  private String fiveCostTypeName;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("primaryCostTypeCode", primaryCostTypeCode);
      map.put("primaryCostTypeName", primaryCostTypeName);
      map.put("lastCostTypeCode", lastCostTypeCode);
      map.put("lastCostTypeName", lastCostTypeName);
      map.put("origin", origin);
      map.put("destination", destination);
      map.put("amount", amount);
      map.put("tripExplain", tripExplain);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("costDate", BocpGenUtils.toTimestamp(costDate));
      map.put("billTemplateDetail", billTemplateDetail);
      map.put("twoCostTypeCode", twoCostTypeCode);
      map.put("twoCostTypeName", twoCostTypeName);
      map.put("threeCostTypeCode", threeCostTypeCode);
      map.put("threeCostTypeName", threeCostTypeName);
      map.put("fourCostTypeCode", fourCostTypeCode);
      map.put("fourCostTypeName", fourCostTypeName);
      map.put("fiveCostTypeCode", fiveCostTypeCode);
      map.put("fiveCostTypeName", fiveCostTypeName);
      return map;
  }

  public static FinancialBasicBillDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    FinancialBasicBillDetail entity = new FinancialBasicBillDetail();
    if(map.containsKey("primaryCostTypeCode")) {
      Object obj = map.get("primaryCostTypeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrimaryCostTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("primaryCostTypeName")) {
      Object obj = map.get("primaryCostTypeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrimaryCostTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lastCostTypeCode")) {
      Object obj = map.get("lastCostTypeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLastCostTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lastCostTypeName")) {
      Object obj = map.get("lastCostTypeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLastCostTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("origin")) {
      Object obj = map.get("origin");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrigin((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("destination")) {
      Object obj = map.get("destination");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDestination((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tripExplain")) {
      Object obj = map.get("tripExplain");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTripExplain((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("costDate")) {
      Object obj = map.get("costDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCostDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCostDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCostDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCostDate(null);
      }
    }
    if(map.containsKey("billTemplateDetail")) {
      Object obj = map.get("billTemplateDetail");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillTemplateDetail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("twoCostTypeCode")) {
      Object obj = map.get("twoCostTypeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTwoCostTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("twoCostTypeName")) {
      Object obj = map.get("twoCostTypeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTwoCostTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("threeCostTypeCode")) {
      Object obj = map.get("threeCostTypeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setThreeCostTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("threeCostTypeName")) {
      Object obj = map.get("threeCostTypeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setThreeCostTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fourCostTypeCode")) {
      Object obj = map.get("fourCostTypeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFourCostTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fourCostTypeName")) {
      Object obj = map.get("fourCostTypeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFourCostTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fiveCostTypeCode")) {
      Object obj = map.get("fiveCostTypeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFiveCostTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fiveCostTypeName")) {
      Object obj = map.get("fiveCostTypeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFiveCostTypeName((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
