package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialBasicBillDetail;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-09-29
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class FinancialCostTypeAdjustBillDetail extends FinancialBasicBillDetail {


  /**
   * 发票形式
   */
  @TableField("invoiceForm")
  private String invoiceForm;

  /**
   * 消费事由
   */
  private String cause;

  /**
   * 是否分摊
   */
  @TableField("ifApportion")
  private String ifApportion;

  /**
   * 分摊项目编码
   */
  @TableField("apportionProjectCode")
  private String apportionProjectCode;

  /**
   * 分摊项目名称
   */
  @TableField("apportionProjectName")
  private String apportionProjectName;

  /**
   * 分摊比例
   */
  @TableField("apportionRatio")
  private String apportionRatio;

  /**
   * 分摊金额
   */
  @TableField("apportionAmount")
  private String apportionAmount;

  /**
   * 标题
   */
  private String title;

  /**
   * Owner编码
   */
  @TableField("ownerCode")
  private String ownerCode;

  /**
   * Owner名称
   */
  @TableField("ownerName")
  private String ownerName;

  /**
   * ChargeCode编码
   */
  @TableField("chargeCode")
  private String chargeCode;

  /**
   * ChargeCode名称
   */
  @TableField("chargeName")
  private String chargeName;

  /**
   * 提交日期
   */
  @TableField("submissionDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime submissionDate;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("invoiceForm", invoiceForm);
      map.put("cause", cause);
      map.put("ifApportion", ifApportion);
      map.put("apportionProjectCode", apportionProjectCode);
      map.put("apportionProjectName", apportionProjectName);
      map.put("apportionRatio", apportionRatio);
      map.put("apportionAmount", apportionAmount);
      map.put("title", title);
      map.put("ownerCode", ownerCode);
      map.put("ownerName", ownerName);
      map.put("chargeCode", chargeCode);
      map.put("chargeName", chargeName);
      map.put("submissionDate", BocpGenUtils.toTimestamp(submissionDate));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static FinancialCostTypeAdjustBillDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    FinancialCostTypeAdjustBillDetail entity = new FinancialCostTypeAdjustBillDetail();
    if(map.containsKey("primaryCostTypeCode")) {
      Object obj = map.get("primaryCostTypeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrimaryCostTypeCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("primaryCostTypeName")) {
      Object obj = map.get("primaryCostTypeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrimaryCostTypeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("lastCostTypeCode")) {
      Object obj = map.get("lastCostTypeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLastCostTypeCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("lastCostTypeName")) {
      Object obj = map.get("lastCostTypeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLastCostTypeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("origin")) {
      Object obj = map.get("origin");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrigin((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("destination")) {
      Object obj = map.get("destination");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDestination((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tripExplain")) {
      Object obj = map.get("tripExplain");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTripExplain((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("costDate")) {
      Object obj = map.get("costDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCostDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCostDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCostDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setCostDate(null);
      }
    }
    if(map.containsKey("billTemplateDetail")) {
      Object obj = map.get("billTemplateDetail");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillTemplateDetail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("twoCostTypeCode")) {
      Object obj = map.get("twoCostTypeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTwoCostTypeCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("twoCostTypeName")) {
      Object obj = map.get("twoCostTypeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTwoCostTypeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("threeCostTypeCode")) {
      Object obj = map.get("threeCostTypeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setThreeCostTypeCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("threeCostTypeName")) {
      Object obj = map.get("threeCostTypeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setThreeCostTypeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("fourCostTypeCode")) {
      Object obj = map.get("fourCostTypeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFourCostTypeCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("fourCostTypeName")) {
      Object obj = map.get("fourCostTypeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFourCostTypeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("fiveCostTypeCode")) {
      Object obj = map.get("fiveCostTypeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFiveCostTypeCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("fiveCostTypeName")) {
      Object obj = map.get("fiveCostTypeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFiveCostTypeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceForm")) {
      Object obj = map.get("invoiceForm");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceForm((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cause")) {
      Object obj = map.get("cause");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCause((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ifApportion")) {
      Object obj = map.get("ifApportion");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIfApportion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("apportionProjectCode")) {
      Object obj = map.get("apportionProjectCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApportionProjectCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("apportionProjectName")) {
      Object obj = map.get("apportionProjectName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApportionProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("apportionRatio")) {
      Object obj = map.get("apportionRatio");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApportionRatio((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("apportionAmount")) {
      Object obj = map.get("apportionAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApportionAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("title")) {
      Object obj = map.get("title");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTitle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ownerCode")) {
      Object obj = map.get("ownerCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOwnerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ownerName")) {
      Object obj = map.get("ownerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOwnerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeCode")) {
      Object obj = map.get("chargeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeName")) {
      Object obj = map.get("chargeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("submissionDate")) {
      Object obj = map.get("submissionDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSubmissionDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSubmissionDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSubmissionDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSubmissionDate(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
