package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.app.financialsettlement.entity.MemberCost;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-09-29
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class MemberShareCost extends MemberCost {


  /**
   * 分摊差异
   */
  @TableField("shareDifferenceAmount")
  private BigDecimal shareDifferenceAmount;

  /**
   * 分摊权重
   */
  @TableField("shareRatio")
  private BigDecimal shareRatio;

  /**
   * 分摊金额
   */
  @TableField("shareAmount")
  private BigDecimal shareAmount;

  /**
   *  分摊后人工成本 
   */
  @TableField("shareCostAmount")
  private BigDecimal shareCostAmount;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("shareDifferenceAmount", shareDifferenceAmount);
      map.put("shareRatio", shareRatio);
      map.put("shareAmount", shareAmount);
      map.put("shareCostAmount", shareCostAmount);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static MemberShareCost fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    MemberShareCost entity = new MemberShareCost();
    if(map.containsKey("chargeMonth")) {
      Object obj = map.get("chargeMonth");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeMonth((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("memberName")) {
      Object obj = map.get("memberName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMemberName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("memberNo")) {
      Object obj = map.get("memberNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMemberNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chargeCode")) {
      Object obj = map.get("chargeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chargeCodeType")) {
      Object obj = map.get("chargeCodeType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeCodeType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("firstDepartmentNo")) {
      Object obj = map.get("firstDepartmentNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFirstDepartmentNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("firstDepartmentName")) {
      Object obj = map.get("firstDepartmentName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFirstDepartmentName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("role")) {
      Object obj = map.get("role");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRole((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rank")) {
      Object obj = map.get("rank");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRank((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cost")) {
      Object obj = map.get("cost");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCost((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCost(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCost(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCost(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCost(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("hours")) {
      Object obj = map.get("hours");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setHours((Long)obj);
        } else if(obj instanceof String) {
          entity.setHours(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setHours(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("memberCost")) {
      Object obj = map.get("memberCost");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setMemberCost((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setMemberCost(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setMemberCost(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setMemberCost(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMemberCost(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("shareDifferenceAmount")) {
      Object obj = map.get("shareDifferenceAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setShareDifferenceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setShareDifferenceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setShareDifferenceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setShareDifferenceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setShareDifferenceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("shareRatio")) {
      Object obj = map.get("shareRatio");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setShareRatio((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setShareRatio(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setShareRatio(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setShareRatio(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setShareRatio(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("shareAmount")) {
      Object obj = map.get("shareAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setShareAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setShareAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setShareAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setShareAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setShareAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("shareCostAmount")) {
      Object obj = map.get("shareCostAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setShareCostAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setShareCostAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setShareCostAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setShareCostAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setShareCostAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
