package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-09-29
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PreComputeTaxAmountInfo implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 订单号
   */
  @TableField("orderNo")
  private String orderNo;

  /**
   * 合同编号
   */
  @TableField("contractNo")
  private String contractNo;

  /**
   * 原始合同id
   */
  @TableField("originContractId")
  private String originContractId;

  /**
   * 客户名称
   */
  @TableField("customName")
  private String customName;

  /**
   * 项目名称
   */
  @TableField("projectName")
  private String projectName;

  /**
   * 项目分期名称
   */
  @TableField("projectItemName")
  private String projectItemName;

  /**
   * 产品名称
   */
  @TableField("productName")
  private String productName;

  /**
   * 产品数量
   */
  @TableField("productNum")
  private BigDecimal productNum;

  /**
   * 产品单价
   */
  @TableField("productSalePrice")
  private BigDecimal productSalePrice;

  /**
   * 税率
   */
  private BigDecimal rate;

  /**
   * 订单总金额(含税)
   */
  @TableField("orderTotalAmountWithTax")
  private BigDecimal orderTotalAmountWithTax;

  /**
   * 订单开票状态
   */
  @TableField("orderInvoiceStatus")
  private String orderInvoiceStatus;

  /**
   * 订单已开票金额
   */
  @TableField("orderReadyInvoiceAmount")
  private BigDecimal orderReadyInvoiceAmount;

  /**
   * 计费税号
   */
  @TableField("taxNo")
  private String taxNo;

  /**
   * 计费公司名称
   */
  @TableField("taxCompanyName")
  private String taxCompanyName;

  /**
   * 计费税号收入总金额（不含税）
   */
  @TableField("sumTaxNoAmount")
  private BigDecimal sumTaxNoAmount;

  /**
   * 计费税号回款金额
   */
  @TableField("taxNoPayBackAmount")
  private BigDecimal taxNoPayBackAmount;

  /**
   * 计费开始日期
   */
  @TableField("taxChargeStartDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime taxChargeStartDate;

  /**
   * 结算开始日期
   */
  @TableField("accountingStartDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime accountingStartDate;

  /**
   * 结算截止日期
   */
  @TableField("accountingEndDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime accountingEndDate;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 产品code
   */
  @TableField("productCode")
  private String productCode;

  /**
   * 项目code
   */
  @TableField("projectCode")
  private String projectCode;

  /**
   * 项目分期code
   */
  @TableField("projectItemCode")
  private String projectItemCode;

  /**
   * 订单状态
   */
  @TableField("orderStatusEnum")
  private String orderStatusEnum;

  /**
   * 数据是否处理
   */
  @TableField("dataStatus")
  private String dataStatus;

  /**
   * 其他信息
   */
  @TableField("extendData")
  private String extendData;

  /**
   *  内部-设备信息
   */
  @TableField("extendDevice")
  private String extendDevice;

  /**
   * 预分配-计费税号回款金额
   */
  @TableField("preTaxNoPayBackAmount")
  private BigDecimal preTaxNoPayBackAmount;

  /**
   * 渠道类型
   */
  @TableField("tenantType")
  private String tenantType;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("orderNo", orderNo);
      map.put("contractNo", contractNo);
      map.put("originContractId", originContractId);
      map.put("customName", customName);
      map.put("projectName", projectName);
      map.put("projectItemName", projectItemName);
      map.put("productName", productName);
      map.put("productNum", productNum);
      map.put("productSalePrice", productSalePrice);
      map.put("rate", rate);
      map.put("orderTotalAmountWithTax", orderTotalAmountWithTax);
      map.put("orderInvoiceStatus", orderInvoiceStatus);
      map.put("orderReadyInvoiceAmount", orderReadyInvoiceAmount);
      map.put("taxNo", taxNo);
      map.put("taxCompanyName", taxCompanyName);
      map.put("sumTaxNoAmount", sumTaxNoAmount);
      map.put("taxNoPayBackAmount", taxNoPayBackAmount);
      map.put("taxChargeStartDate", BocpGenUtils.toTimestamp(taxChargeStartDate));
      map.put("accountingStartDate", BocpGenUtils.toTimestamp(accountingStartDate));
      map.put("accountingEndDate", BocpGenUtils.toTimestamp(accountingEndDate));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("productCode", productCode);
      map.put("projectCode", projectCode);
      map.put("projectItemCode", projectItemCode);
      map.put("orderStatusEnum", orderStatusEnum);
      map.put("dataStatus", dataStatus);
      map.put("extendData", extendData);
      map.put("extendDevice", extendDevice);
      map.put("preTaxNoPayBackAmount", preTaxNoPayBackAmount);
      map.put("tenantType", tenantType);
      return map;
  }

  public static PreComputeTaxAmountInfo fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PreComputeTaxAmountInfo entity = new PreComputeTaxAmountInfo();
    if(map.containsKey("orderNo")) {
      Object obj = map.get("orderNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originContractId")) {
      Object obj = map.get("originContractId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginContractId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customName")) {
      Object obj = map.get("customName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustomName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectItemName")) {
      Object obj = map.get("projectItemName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productNum")) {
      Object obj = map.get("productNum");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setProductNum((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setProductNum(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setProductNum(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setProductNum(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setProductNum(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("productSalePrice")) {
      Object obj = map.get("productSalePrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setProductSalePrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setProductSalePrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setProductSalePrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setProductSalePrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setProductSalePrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("rate")) {
      Object obj = map.get("rate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("orderTotalAmountWithTax")) {
      Object obj = map.get("orderTotalAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOrderTotalAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOrderTotalAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOrderTotalAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setOrderTotalAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderTotalAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("orderInvoiceStatus")) {
      Object obj = map.get("orderInvoiceStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderReadyInvoiceAmount")) {
      Object obj = map.get("orderReadyInvoiceAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOrderReadyInvoiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOrderReadyInvoiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOrderReadyInvoiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setOrderReadyInvoiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderReadyInvoiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxNo")) {
      Object obj = map.get("taxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxCompanyName")) {
      Object obj = map.get("taxCompanyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sumTaxNoAmount")) {
      Object obj = map.get("sumTaxNoAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSumTaxNoAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSumTaxNoAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSumTaxNoAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setSumTaxNoAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSumTaxNoAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxNoPayBackAmount")) {
      Object obj = map.get("taxNoPayBackAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxNoPayBackAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxNoPayBackAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxNoPayBackAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxNoPayBackAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxNoPayBackAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxChargeStartDate")) {
      Object obj = map.get("taxChargeStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTaxChargeStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setTaxChargeStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setTaxChargeStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTaxChargeStartDate(null);
      }
    }
    if(map.containsKey("accountingStartDate")) {
      Object obj = map.get("accountingStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountingStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAccountingStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAccountingStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAccountingStartDate(null);
      }
    }
    if(map.containsKey("accountingEndDate")) {
      Object obj = map.get("accountingEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountingEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAccountingEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAccountingEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAccountingEndDate(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectCode")) {
      Object obj = map.get("projectCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectItemCode")) {
      Object obj = map.get("projectItemCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderStatusEnum")) {
      Object obj = map.get("orderStatusEnum");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderStatusEnum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataStatus")) {
      Object obj = map.get("dataStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDataStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extendData")) {
      Object obj = map.get("extendData");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtendData((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extendDevice")) {
      Object obj = map.get("extendDevice");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtendDevice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("preTaxNoPayBackAmount")) {
      Object obj = map.get("preTaxNoPayBackAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPreTaxNoPayBackAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPreTaxNoPayBackAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPreTaxNoPayBackAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPreTaxNoPayBackAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPreTaxNoPayBackAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tenantType")) {
      Object obj = map.get("tenantType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantType((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
