package com.xforceplus.ultraman.app.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 合同类型
 * </p>
 *
 * @author ultraman
 * @since 2023-03-30
 */
public enum ContractTypes {

    _0("0", "主合同"),
    _1("1", "补充协议"),
    _2("2", "续费合同"),
    _3("3", "战略合作框架合同"),
    _4("4", "试用合同"),
    _5("5", "平台对接合同"),
    _6("6", "提前进场"),
    _7("7", "采购合同");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ContractTypes(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ContractTypes fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            default:
                return null;
        }
    }
}
