package com.xforceplus.ultraman.app.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 费用科目
 * </p>
 *
 * @author ultraman
 * @since 2023-03-30
 */
public enum CostItem {

    COST16("COST16", "差旅费"),
    COST85("COST85", "其他交通费（地铁、公交车、出租车）"),
    COST82("COST82", "火车（单程）"),
    COST146("COST146", "火车(单程)_企业支付"),
    COST147("COST147", "火车(单程)_个人支付"),
    COST201("COST201", "火车(单程)_企业支付_无票"),
    COST83("COST83", "机票（单程）"),
    COST148("COST148", "机票(单程)_企业支付"),
    COST149("COST149", "机票(单程)_个人支付"),
    COST202("COST202", "机票(单程)_企业支付_补报"),
    COST84("COST84", "住宿费"),
    COST203("COST203", "住宿费_企业支付_补报"),
    COST93("COST93", "住宿费_企业支付"),
    COST94("COST94", "住宿费_个人支付"),
    COST140("COST140", "网约打车费"),
    COST86("COST86", "网约打车费_企业支付_差旅费"),
    COST214("COST214", "网约打车费_个人支付"),
    COST139("COST139", "网约打车费_企业支付_市内交通费"),
    COST90("COST90", "差旅补贴"),
    COST141("COST141", "私车公用"),
    COST87("COST87", "过路费"),
    COST88("COST88", "停车费"),
    COST89("COST89", "油费补贴"),
    COST170("COST170", "核酸检测"),
    COST198("COST198", "退改签费用"),
    COST199("COST199", "退改签费用_企业支付"),
    COST200("COST200", "退改签费用_个人支付"),
    COST17("COST17", "业务招待费"),
    COST164("COST164", "礼品礼盒"),
    COST227("COST227", "业务关系维系费—调整"),
    COST80("COST80", "业务关系维系费"),
    COST81("COST81", "公共关系维护费"),
    COST18("COST18", "市内交通费"),
    COST197("COST197", "核酸检测"),
    COST75("COST75", "其他交通费（地铁、公交车、出租车）"),
    COST76("COST76", "市内网约打车费"),
    COST145("COST145", "市内网约打车费_企业支付"),
    COST172("COST172", "市内网约打车费_个人支付"),
    COST77("COST77", "过路费"),
    COST78("COST78", "停车费"),
    COST79("COST79", "油费补贴"),
    COST19("COST19", "行政办公费"),
    COST192("COST192", "公车费用"),
    COST217("COST217", "办公用品等—调整"),
    COST47("COST47", "装修费用"),
    COST66("COST66", "办公用品等"),
    COST67("COST67", "保洁费"),
    COST68("COST68", "电信费"),
    COST69("COST69", "快递费"),
    COST70("COST70", "绿植租赁费"),
    COST73("COST73", "行政维修费"),
    COST74("COST74", "水电费"),
    COST20("COST20", "房租物业"),
    COST64("COST64", "房屋租赁费"),
    COST65("COST65", "物业费"),
    COST21("COST21", "福利费"),
    COST218("COST218", "日常福利—调整"),
    COST63("COST63", "日常福利"),
    COST22("COST22", "团建活动费"),
    COST62("COST62", "团建费"),
    COST23("COST23", "计算机及相关办公设备"),
    COST221("COST221", "计算机及相关设备—调整"),
    COST59("COST59", "计算机及相关设备"),
    COST60("COST60", "家具"),
    COST61("COST61", "其他资产"),
    COST24("COST24", "培训会议费"),
    COST150("COST150", "培训物料"),
    COST226("COST226", "培训物料—调整"),
    COST57("COST57", "培训费"),
    COST58("COST58", "会议费"),
    COST25("COST25", "云资通道及托管服务"),
    COST151("COST151", "云资源（阿里云、腾讯云、AWS华讯）"),
    COST152("COST152", "通道服务"),
    COST153("COST153", "OCR识别服务（探智立方、睿真）"),
    COST154("COST154", "IDC租赁（宝之云、点诺）"),
    COST230("COST230", "服务器配件—调整"),
    COST231("COST231", "其他税件相关—调整"),
    COST36("COST36", "服务器配件"),
    COST39("COST39", "税控设备"),
    COST56("COST56", "其他税件相关"),
    COST26("COST26", "市场服务费"),
    COST155("COST155", "广告宣传费"),
    COST156("COST156", "其他市场服务费（展会、赞助等活动费）"),
    COST228("COST228", "市场服务费—调整"),
    COST55("COST55", "市场服务费"),
    COST27("COST27", "项目外购"),
    COST189("COST189", "项目房屋租赁"),
    COST190("COST190", "外协服务费（项目外包服务费）"),
    COST222("COST222", "外协服务费（项目外包服务费）—调整"),
    COST54("COST54", "外购软硬件"),
    COST31("COST31", "外购硬件"),
    COST32("COST32", "发票扫描仪"),
    COST33("COST33", "开票机器人"),
    COST34("COST34", "底账服务器"),
    COST35("COST35", "电票服务器"),
    COST37("COST37", "红黑激光发票打印机及耗材"),
    COST38("COST38", "签名认证服务器"),
    COST216("COST216", "外购软件"),
    COST30("COST30", "综合服务费"),
    COST196("COST196", "客服通讯费"),
    COST219("COST219", "客服通讯费—调整"),
    COST223("COST223", "自用软件服务费—调整"),
    COST224("COST224", "认证服务费—调整"),
    COST225("COST225", "招聘费—调整"),
    COST229("COST229", "其他综合服务费—调整"),
    COST40("COST40", "认证服务费"),
    COST41("COST41", "专业服务费"),
    COST42("COST42", "法律服务费"),
    COST43("COST43", "管理咨询"),
    COST44("COST44", "其他综合服务费"),
    COST45("COST45", "自用软件服务费"),
    COST46("COST46", "招聘费"),
    COST158("COST158", "其他产品服务费"),
    COST159("COST159", "其他产品服务费"),
    COST220("COST220", "其他产品服务费—调整"),
    COST173("COST173", "工资薪金"),
    COST174("COST174", "工资薪金_第三方代付"),
    COST175("COST175", "工资薪金_银行代付"),
    COST176("COST176", "员工商保"),
    COST177("COST177", "社保_公积金_薪资服务费"),
    COST182("COST182", "外包服务费"),
    COST185("COST185", "非采购项目"),
    COST28("COST28", "押金|保证金"),
    COST142("COST142", "行政办公押金"),
    COST143("COST143", "项目设备押金"),
    COST48("COST48", "房屋押金"),
    COST50("COST50", "投标保证金"),
    COST161("COST161", "结算手续费"),
    COST169("COST169", "专项服务费"),
    COST186("COST186", "其他项目（例如：公益项目）"),
    COST195("COST195", "关联方服务费"),
    COST204("COST204", "工会费用"),
    COST205("COST205", "员工生日福利"),
    COST206("COST206", "结婚慰问"),
    COST207("COST207", "生育慰问"),
    COST208("COST208", "加班项目慰问"),
    COST209("COST209", "献血生病慰问"),
    COST210("COST210", "丧事慰问"),
    COST211("COST211", "工会活动支出"),
    COST212("COST212", "备用金申请"),
    COST213("COST213", "其他支出"),
    COST215("COST215", "退款明细"),
    COST187("COST187", "差旅相关平台充值(合思商城、滴滴、携程等)"),
    COST188("COST188", "差旅相关平台充值");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    CostItem(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CostItem fromCode(String code){
        switch(code) {
            case "COST16":
                return COST16;
            case "COST85":
                return COST85;
            case "COST82":
                return COST82;
            case "COST146":
                return COST146;
            case "COST147":
                return COST147;
            case "COST201":
                return COST201;
            case "COST83":
                return COST83;
            case "COST148":
                return COST148;
            case "COST149":
                return COST149;
            case "COST202":
                return COST202;
            case "COST84":
                return COST84;
            case "COST203":
                return COST203;
            case "COST93":
                return COST93;
            case "COST94":
                return COST94;
            case "COST140":
                return COST140;
            case "COST86":
                return COST86;
            case "COST214":
                return COST214;
            case "COST139":
                return COST139;
            case "COST90":
                return COST90;
            case "COST141":
                return COST141;
            case "COST87":
                return COST87;
            case "COST88":
                return COST88;
            case "COST89":
                return COST89;
            case "COST170":
                return COST170;
            case "COST198":
                return COST198;
            case "COST199":
                return COST199;
            case "COST200":
                return COST200;
            case "COST17":
                return COST17;
            case "COST164":
                return COST164;
            case "COST227":
                return COST227;
            case "COST80":
                return COST80;
            case "COST81":
                return COST81;
            case "COST18":
                return COST18;
            case "COST197":
                return COST197;
            case "COST75":
                return COST75;
            case "COST76":
                return COST76;
            case "COST145":
                return COST145;
            case "COST172":
                return COST172;
            case "COST77":
                return COST77;
            case "COST78":
                return COST78;
            case "COST79":
                return COST79;
            case "COST19":
                return COST19;
            case "COST192":
                return COST192;
            case "COST217":
                return COST217;
            case "COST47":
                return COST47;
            case "COST66":
                return COST66;
            case "COST67":
                return COST67;
            case "COST68":
                return COST68;
            case "COST69":
                return COST69;
            case "COST70":
                return COST70;
            case "COST73":
                return COST73;
            case "COST74":
                return COST74;
            case "COST20":
                return COST20;
            case "COST64":
                return COST64;
            case "COST65":
                return COST65;
            case "COST21":
                return COST21;
            case "COST218":
                return COST218;
            case "COST63":
                return COST63;
            case "COST22":
                return COST22;
            case "COST62":
                return COST62;
            case "COST23":
                return COST23;
            case "COST221":
                return COST221;
            case "COST59":
                return COST59;
            case "COST60":
                return COST60;
            case "COST61":
                return COST61;
            case "COST24":
                return COST24;
            case "COST150":
                return COST150;
            case "COST226":
                return COST226;
            case "COST57":
                return COST57;
            case "COST58":
                return COST58;
            case "COST25":
                return COST25;
            case "COST151":
                return COST151;
            case "COST152":
                return COST152;
            case "COST153":
                return COST153;
            case "COST154":
                return COST154;
            case "COST230":
                return COST230;
            case "COST231":
                return COST231;
            case "COST36":
                return COST36;
            case "COST39":
                return COST39;
            case "COST56":
                return COST56;
            case "COST26":
                return COST26;
            case "COST155":
                return COST155;
            case "COST156":
                return COST156;
            case "COST228":
                return COST228;
            case "COST55":
                return COST55;
            case "COST27":
                return COST27;
            case "COST189":
                return COST189;
            case "COST190":
                return COST190;
            case "COST222":
                return COST222;
            case "COST54":
                return COST54;
            case "COST31":
                return COST31;
            case "COST32":
                return COST32;
            case "COST33":
                return COST33;
            case "COST34":
                return COST34;
            case "COST35":
                return COST35;
            case "COST37":
                return COST37;
            case "COST38":
                return COST38;
            case "COST216":
                return COST216;
            case "COST30":
                return COST30;
            case "COST196":
                return COST196;
            case "COST219":
                return COST219;
            case "COST223":
                return COST223;
            case "COST224":
                return COST224;
            case "COST225":
                return COST225;
            case "COST229":
                return COST229;
            case "COST40":
                return COST40;
            case "COST41":
                return COST41;
            case "COST42":
                return COST42;
            case "COST43":
                return COST43;
            case "COST44":
                return COST44;
            case "COST45":
                return COST45;
            case "COST46":
                return COST46;
            case "COST158":
                return COST158;
            case "COST159":
                return COST159;
            case "COST220":
                return COST220;
            case "COST173":
                return COST173;
            case "COST174":
                return COST174;
            case "COST175":
                return COST175;
            case "COST176":
                return COST176;
            case "COST177":
                return COST177;
            case "COST182":
                return COST182;
            case "COST185":
                return COST185;
            case "COST28":
                return COST28;
            case "COST142":
                return COST142;
            case "COST143":
                return COST143;
            case "COST48":
                return COST48;
            case "COST50":
                return COST50;
            case "COST161":
                return COST161;
            case "COST169":
                return COST169;
            case "COST186":
                return COST186;
            case "COST195":
                return COST195;
            case "COST204":
                return COST204;
            case "COST205":
                return COST205;
            case "COST206":
                return COST206;
            case "COST207":
                return COST207;
            case "COST208":
                return COST208;
            case "COST209":
                return COST209;
            case "COST210":
                return COST210;
            case "COST211":
                return COST211;
            case "COST212":
                return COST212;
            case "COST213":
                return COST213;
            case "COST215":
                return COST215;
            case "COST187":
                return COST187;
            case "COST188":
                return COST188;
            default:
                return null;
        }
    }
}
