package com.xforceplus.ultraman.app.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 维度说明
 * </p>
 *
 * @author ultraman
 * @since 2023-03-30
 */
public enum DimensionEnum {

    ORDER("order", "订单"),
    TAX("tax", "税号"),
    INVOICE("invoice", "发票"),
    PAY_WATER("payWater", "回款流水");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DimensionEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DimensionEnum fromCode(String code){
        switch(code) {
            case "order":
                return ORDER;
            case "tax":
                return TAX;
            case "invoice":
                return INVOICE;
            case "payWater":
                return PAY_WATER;
            default:
                return null;
        }
    }
}
