package com.xforceplus.ultraman.app.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 回款流水数据来源枚举
 * </p>
 *
 * @author ultraman
 * @since 2023-03-30
 */
public enum NotTakenChannelEnum {

    IMPORT("import", "文件导入"),
    NBCB("nbcb", "宁波银行");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    NotTakenChannelEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static NotTakenChannelEnum fromCode(String code){
        switch(code) {
            case "import":
                return IMPORT;
            case "nbcb":
                return NBCB;
            default:
                return null;
        }
    }
}
