package com.xforceplus.ultraman.app.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 项目阶段状态
 * </p>
 *
 * @author ultraman
 * @since 2023-03-30
 */
public enum ProjectStageStatus {

    NOT_STARTING("notStarting", "未开始"),
    PROCESSING("processing", "进行中"),
    FINISHED("finished", "已完成"),
    STOP("stop", "已终止");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ProjectStageStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProjectStageStatus fromCode(String code){
        switch(code) {
            case "notStarting":
                return NOT_STARTING;
            case "processing":
                return PROCESSING;
            case "finished":
                return FINISHED;
            case "stop":
                return STOP;
            default:
                return null;
        }
    }
}
