package com.xforceplus.ultraman.app.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 记录类型
 * </p>
 *
 * @author ultraman
 * @since 2023-03-30
 */
public enum RecordType {

    _0("0", "新增合同"),
    _1("1", "更新合同"),
    _2("2", "新增计费流水"),
    _3("3", "新增订单"),
    _4("4", "更新订单"),
    _5("5", "新增结算对账明细"),
    _6("6", "新增结算对账单");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    RecordType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RecordType fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            default:
                return null;
        }
    }
}
