package com.xforceplus.ultraman.app.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * small_orderservice_close_type
 * </p>
 *
 * @author ultraman
 * @since 2023-11-22
 */
public enum SmallOrderserviceCloseType {

    UPGRADE("UPGRADE", "升级"),
    REFUND("REFUND", "退款关闭"),
    UNPAID("UNPAID", "逾期未支付"),
    MANUAL("MANUAL", "用户手工关闭");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SmallOrderserviceCloseType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SmallOrderserviceCloseType fromCode(String code){
        switch(code) {
            case "UPGRADE":
                return UPGRADE;
            case "REFUND":
                return REFUND;
            case "UNPAID":
                return UNPAID;
            case "MANUAL":
                return MANUAL;
            default:
                return null;
        }
    }
}
