package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 结算单明细表-税号
 * </p>
 *
 * @author ultraman
 * @since 2023-11-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BillDetail implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 对账单明细单号
   */
  @TableField("billDetailNo")
  private String billDetailNo;

  /**
   * 合同号
   */
  @TableField("contractNo")
  private String contractNo;

  /**
   * 产品编号
   */
  @TableField("productNo")
  private String productNo;

  /**
   * 计费类型
   */
  @TableField("chargeType")
  private String chargeType;

  /**
   * 付费方式
   */
  @TableField("paymentMethod")
  private String paymentMethod;

  /**
   * 售价（不含税）
   */
  @TableField("salePriceWithoutTax")
  private BigDecimal salePriceWithoutTax;

  /**
   * 单价（不含税）
   */
  @TableField("unitAmountWithoutTax")
  private BigDecimal unitAmountWithoutTax;

  /**
   * 本期应结算金额（含税）
   */
  @TableField("currentPayableAmountWithTax")
  private BigDecimal currentPayableAmountWithTax;

  /**
   * 税率
   */
  @TableField("taxRate")
  private String taxRate;

  /**
   * 税号
   */
  @TableField("taxNo")
  private String taxNo;

  /**
   * 税号公司名称
   */
  @TableField("taxCompanyName")
  private String taxCompanyName;

  /**
   * 结算开始日期
   */
  @TableField("accountingStartDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime accountingStartDate;

  /**
   * 结算结束日期
   */
  @TableField("accountingEndDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime accountingEndDate;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 结算单主号
   */
  @TableField("billNo")
  private String billNo;

  /**
   * B租户代码
   */
  @TableField("bTenantCode")
  private String bTenantCode;

  /**
   * B租户id
   */
  @TableField("bTenantId")
  private Long bTenantId;

  /**
   * 税号开通时间
   */
  @TableField("taxBillingDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime taxBillingDate;

  /**
   * 状态
   */
  private String status;

  /**
   * 本期优惠金额(含税)
   */
  @TableField("discountAmount")
  private BigDecimal discountAmount;

  /**
   * 本期优惠折抵后应结算金额（含税）
   */
  @TableField("currentPayableAmountWithTaxAfterDiscount")
  private BigDecimal currentPayableAmountWithTaxAfterDiscount;

  /**
   * 本期优惠折抵后应结算金额（不含税）
   */
  @TableField("currentPayableAmountWithoutTaxAfterDiscount")
  private BigDecimal currentPayableAmountWithoutTaxAfterDiscount;

  /**
   * 产品名称
   */
  @TableField("productName")
  private String productName;

  /**
   * 内部处理状态
   */
  @TableField("handleStatus")
  private String handleStatus;

  /**
   * 计费给的合同id-内部
   */
  @TableField("originContractId")
  private String originContractId;

  /**
   * 本期折抵金额（含税）
   */
  @TableField("reducedAmountWithTax")
  private BigDecimal reducedAmountWithTax;

  /**
   * 设备类型
   */
  @TableField("deviceType")
  private String deviceType;

  /**
   * 设备编号
   */
  @TableField("deviceNo")
  private String deviceNo;

  /**
   * 设备开始时间
   */
  @TableField("deviceStartDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime deviceStartDate;

  /**
   * 设备结束时间
   */
  @TableField("deviceEndDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime deviceEndDate;

  /**
   * 渠道类型
   */
  @TableField("tenantType")
  private String tenantType;


  /**
   * 对一关联关系 关联对象 bill
   */
    private Long oneToManyDetailId;
  /**
   * 对一关联关系 关联对象 orderInfo
   */
    private Long settlementDetailToOrderId;
  /**
   * 对一关联关系 关联对象 billStaticsDetail
   */
    private Long oneSettlementDetailToOneReconciliationDetailId;
  /**
   * 对一关联关系 关联对象 orderInfo
   */
    private Long orderToManySettlementDetailId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("billDetailNo", billDetailNo);
      map.put("contractNo", contractNo);
      map.put("productNo", productNo);
      map.put("chargeType", chargeType);
      map.put("paymentMethod", paymentMethod);
      map.put("salePriceWithoutTax", salePriceWithoutTax);
      map.put("unitAmountWithoutTax", unitAmountWithoutTax);
      map.put("currentPayableAmountWithTax", currentPayableAmountWithTax);
      map.put("taxRate", taxRate);
      map.put("taxNo", taxNo);
      map.put("taxCompanyName", taxCompanyName);
      map.put("accountingStartDate", BocpGenUtils.toTimestamp(accountingStartDate));
      map.put("accountingEndDate", BocpGenUtils.toTimestamp(accountingEndDate));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("billNo", billNo);
      map.put("bTenantCode", bTenantCode);
      map.put("bTenantId", bTenantId);
      map.put("taxBillingDate", BocpGenUtils.toTimestamp(taxBillingDate));
      map.put("status", status);
      map.put("discountAmount", discountAmount);
      map.put("currentPayableAmountWithTaxAfterDiscount", currentPayableAmountWithTaxAfterDiscount);
      map.put("currentPayableAmountWithoutTaxAfterDiscount", currentPayableAmountWithoutTaxAfterDiscount);
      map.put("productName", productName);
      map.put("handleStatus", handleStatus);
      map.put("originContractId", originContractId);
      map.put("reducedAmountWithTax", reducedAmountWithTax);
      map.put("deviceType", deviceType);
      map.put("deviceNo", deviceNo);
      map.put("deviceStartDate", BocpGenUtils.toTimestamp(deviceStartDate));
      map.put("deviceEndDate", BocpGenUtils.toTimestamp(deviceEndDate));
      map.put("tenantType", tenantType);

       map.put("oneToManyDetail.id", oneToManyDetailId);
       map.put("settlementDetailToOrder.id", settlementDetailToOrderId);
       map.put("oneSettlementDetailToOneReconciliationDetail.id", oneSettlementDetailToOneReconciliationDetailId);
       map.put("orderToManySettlementDetail.id", orderToManySettlementDetailId);
      return map;
  }

  public static BillDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    BillDetail entity = new BillDetail();
    if(map.containsKey("billDetailNo")) {
      Object obj = map.get("billDetailNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillDetailNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productNo")) {
      Object obj = map.get("productNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeType")) {
      Object obj = map.get("chargeType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentMethod")) {
      Object obj = map.get("paymentMethod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salePriceWithoutTax")) {
      Object obj = map.get("salePriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSalePriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSalePriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSalePriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSalePriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSalePriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unitAmountWithoutTax")) {
      Object obj = map.get("unitAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUnitAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("currentPayableAmountWithTax")) {
      Object obj = map.get("currentPayableAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCurrentPayableAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCurrentPayableAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCurrentPayableAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCurrentPayableAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCurrentPayableAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxNo")) {
      Object obj = map.get("taxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxCompanyName")) {
      Object obj = map.get("taxCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountingStartDate")) {
      Object obj = map.get("accountingStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountingStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setAccountingStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAccountingStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAccountingStartDate(null);
      }
    }
    if(map.containsKey("accountingEndDate")) {
      Object obj = map.get("accountingEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountingEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setAccountingEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAccountingEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAccountingEndDate(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billNo")) {
      Object obj = map.get("billNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bTenantCode")) {
      Object obj = map.get("bTenantCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bTenantId")) {
      Object obj = map.get("bTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("taxBillingDate")) {
      Object obj = map.get("taxBillingDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTaxBillingDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setTaxBillingDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxBillingDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTaxBillingDate(null);
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discountAmount")) {
      Object obj = map.get("discountAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiscountAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("currentPayableAmountWithTaxAfterDiscount")) {
      Object obj = map.get("currentPayableAmountWithTaxAfterDiscount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCurrentPayableAmountWithTaxAfterDiscount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCurrentPayableAmountWithTaxAfterDiscount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCurrentPayableAmountWithTaxAfterDiscount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCurrentPayableAmountWithTaxAfterDiscount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCurrentPayableAmountWithTaxAfterDiscount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("currentPayableAmountWithoutTaxAfterDiscount")) {
      Object obj = map.get("currentPayableAmountWithoutTaxAfterDiscount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCurrentPayableAmountWithoutTaxAfterDiscount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCurrentPayableAmountWithoutTaxAfterDiscount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCurrentPayableAmountWithoutTaxAfterDiscount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCurrentPayableAmountWithoutTaxAfterDiscount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCurrentPayableAmountWithoutTaxAfterDiscount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("handleStatus")) {
      Object obj = map.get("handleStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHandleStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originContractId")) {
      Object obj = map.get("originContractId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginContractId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reducedAmountWithTax")) {
      Object obj = map.get("reducedAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReducedAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReducedAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReducedAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReducedAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReducedAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("deviceType")) {
      Object obj = map.get("deviceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeviceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deviceNo")) {
      Object obj = map.get("deviceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeviceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deviceStartDate")) {
      Object obj = map.get("deviceStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDeviceStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setDeviceStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDeviceStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDeviceStartDate(null);
      }
    }
    if(map.containsKey("deviceEndDate")) {
      Object obj = map.get("deviceEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDeviceEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setDeviceEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDeviceEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDeviceEndDate(null);
      }
    }
    if(map.containsKey("tenantType")) {
      Object obj = map.get("tenantType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantType((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("oneToManyDetail.id")) {
        Object obj = map.get("oneToManyDetail.id");
      if(obj instanceof Long) {
        entity.setOneToManyDetailId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setOneToManyDetailId(Long.parseLong((String)obj));
      }
    }
    if(map.containsKey("settlementDetailToOrder.id")) {
        Object obj = map.get("settlementDetailToOrder.id");
      if(obj instanceof Long) {
        entity.setSettlementDetailToOrderId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setSettlementDetailToOrderId(Long.parseLong((String)obj));
      }
    }
    if(map.containsKey("oneSettlementDetailToOneReconciliationDetail.id")) {
        Object obj = map.get("oneSettlementDetailToOneReconciliationDetail.id");
      if(obj instanceof Long) {
        entity.setOneSettlementDetailToOneReconciliationDetailId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setOneSettlementDetailToOneReconciliationDetailId(Long.parseLong((String)obj));
      }
    }
    if(map.containsKey("orderToManySettlementDetail.id")) {
        Object obj = map.get("orderToManySettlementDetail.id");
      if(obj instanceof Long) {
        entity.setOrderToManySettlementDetailId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setOrderToManySettlementDetailId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("billDetailNo")) {
      Object obj = map.get("billDetailNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillDetailNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setContractNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("productNo")) {
      Object obj = map.get("productNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProductNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chargeType")) {
      Object obj = map.get("chargeType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paymentMethod")) {
      Object obj = map.get("paymentMethod");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentMethod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salePriceWithoutTax")) {
      Object obj = map.get("salePriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSalePriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSalePriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSalePriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSalePriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSalePriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("unitAmountWithoutTax")) {
      Object obj = map.get("unitAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setUnitAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setUnitAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setUnitAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUnitAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setUnitAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("currentPayableAmountWithTax")) {
      Object obj = map.get("currentPayableAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCurrentPayableAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCurrentPayableAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCurrentPayableAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCurrentPayableAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCurrentPayableAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxRate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxNo")) {
      Object obj = map.get("taxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxCompanyName")) {
      Object obj = map.get("taxCompanyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("accountingStartDate")) {
      Object obj = map.get("accountingStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAccountingStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setAccountingStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAccountingStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setAccountingStartDate(null);
      }
    }
    if(map.containsKey("accountingEndDate")) {
      Object obj = map.get("accountingEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAccountingEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setAccountingEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAccountingEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setAccountingEndDate(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billNo")) {
      Object obj = map.get("billNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bTenantCode")) {
      Object obj = map.get("bTenantCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bTenantId")) {
      Object obj = map.get("bTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setBTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("taxBillingDate")) {
      Object obj = map.get("taxBillingDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTaxBillingDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setTaxBillingDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxBillingDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setTaxBillingDate(null);
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("discountAmount")) {
      Object obj = map.get("discountAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDiscountAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDiscountAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDiscountAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDiscountAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDiscountAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("currentPayableAmountWithTaxAfterDiscount")) {
      Object obj = map.get("currentPayableAmountWithTaxAfterDiscount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCurrentPayableAmountWithTaxAfterDiscount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCurrentPayableAmountWithTaxAfterDiscount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCurrentPayableAmountWithTaxAfterDiscount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCurrentPayableAmountWithTaxAfterDiscount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCurrentPayableAmountWithTaxAfterDiscount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("currentPayableAmountWithoutTaxAfterDiscount")) {
      Object obj = map.get("currentPayableAmountWithoutTaxAfterDiscount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCurrentPayableAmountWithoutTaxAfterDiscount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCurrentPayableAmountWithoutTaxAfterDiscount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCurrentPayableAmountWithoutTaxAfterDiscount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCurrentPayableAmountWithoutTaxAfterDiscount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCurrentPayableAmountWithoutTaxAfterDiscount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProductName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("handleStatus")) {
      Object obj = map.get("handleStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHandleStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originContractId")) {
      Object obj = map.get("originContractId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginContractId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reducedAmountWithTax")) {
      Object obj = map.get("reducedAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setReducedAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setReducedAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setReducedAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReducedAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setReducedAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("deviceType")) {
      Object obj = map.get("deviceType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeviceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deviceNo")) {
      Object obj = map.get("deviceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeviceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deviceStartDate")) {
      Object obj = map.get("deviceStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDeviceStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setDeviceStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDeviceStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setDeviceStartDate(null);
      }
    }
    if(map.containsKey("deviceEndDate")) {
      Object obj = map.get("deviceEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDeviceEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setDeviceEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDeviceEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setDeviceEndDate(null);
      }
    }
    if(map.containsKey("tenantType")) {
      Object obj = map.get("tenantType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantType((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("oneToManyDetail.id")) {
        Object obj = map.get("oneToManyDetail.id");
        if(obj instanceof Long) {
          this.setOneToManyDetailId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOneToManyDetailId(Long.parseLong((String)obj));
        }
      }
      if(map.containsKey("settlementDetailToOrder.id")) {
        Object obj = map.get("settlementDetailToOrder.id");
        if(obj instanceof Long) {
          this.setSettlementDetailToOrderId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSettlementDetailToOrderId(Long.parseLong((String)obj));
        }
      }
      if(map.containsKey("oneSettlementDetailToOneReconciliationDetail.id")) {
        Object obj = map.get("oneSettlementDetailToOneReconciliationDetail.id");
        if(obj instanceof Long) {
          this.setOneSettlementDetailToOneReconciliationDetailId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOneSettlementDetailToOneReconciliationDetailId(Long.parseLong((String)obj));
        }
      }
      if(map.containsKey("orderToManySettlementDetail.id")) {
        Object obj = map.get("orderToManySettlementDetail.id");
        if(obj instanceof Long) {
          this.setOrderToManySettlementDetailId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderToManySettlementDetailId(Long.parseLong((String)obj));
        }
      }
  }
}
