package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-11-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BillStaticsDetail implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 对账单明细单号
   */
  @TableField("billDetailNo")
  private String billDetailNo;

  /**
   * 合同号
   */
  @TableField("contractNo")
  private String contractNo;

  /**
   * 产品编号
   */
  @TableField("productNo")
  private String productNo;

  /**
   * 计费类型
   */
  @TableField("chargeType")
  private String chargeType;

  /**
   * 售价（不含税）
   */
  @TableField("salePriceWithoutTax")
  private String salePriceWithoutTax;

  /**
   * 单价（不含税）
   */
  @TableField("unitAmountWithoutTax")
  private String unitAmountWithoutTax;

  /**
   * 本期应结算金额（含税）
   */
  @TableField("currentPayableAmountWithTax")
  private String currentPayableAmountWithTax;

  /**
   * 税率
   */
  @TableField("taxRate")
  private String taxRate;

  /**
   * 使用公司税号
   */
  @TableField("taxNo")
  private String taxNo;

  /**
   * 使用公司名称
   */
  @TableField("taxCompanyName")
  private String taxCompanyName;

  /**
   * 结算开始日期
   */
  @TableField("accountingStartDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime accountingStartDate;

  /**
   * 结算结束日期
   */
  @TableField("accountingEndDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime accountingEndDate;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 发票代码
   */
  @TableField("invoiceCode")
  private String invoiceCode;

  /**
   * 发票号码
   */
  @TableField("invoiceNo")
  private String invoiceNo;

  /**
   * 待核销金额--作废
   */
  @TableField("waitingAmount")
  private BigDecimal waitingAmount;

  /**
   * 已核销金额--作废
   */
  @TableField("readyAmount")
  private BigDecimal readyAmount;

  /**
   * 订单号
   */
  @TableField("orderNo")
  private String orderNo;

  /**
   * 付费类型
   */
  @TableField("paymentType")
  private String paymentType;

  /**
   * 付款条件
   */
  @TableField("paymentRequirement")
  private String paymentRequirement;

  /**
   * 性质
   */
  private String property;

  /**
   * 数量
   */
  private BigDecimal quantity;

  /**
   * 计价单位
   */
  @TableField("chargeUnit")
  private String chargeUnit;

  /**
   * 计费天数
   */
  @TableField("chargeDays")
  private Long chargeDays;

  /**
   * 结算周期
   */
  @TableField("chargeCycle")
  private String chargeCycle;

  /**
   * 对账单创建日期
   */
  @TableField("billCreateDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime billCreateDate;

  /**
   * 发票抬头公司名称
   */
  @TableField("invoiceCompanyName")
  private String invoiceCompanyName;

  /**
   * 发票抬头公司税号
   */
  @TableField("invoiceCompanyTaxNo")
  private String invoiceCompanyTaxNo;

  /**
   * 开票日期
   */
  @TableField("invoiceGenerateDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime invoiceGenerateDate;

  /**
   * 开票金额（不含税）
   */
  @TableField("invoiceAmountWithoutTax")
  private BigDecimal invoiceAmountWithoutTax;

  /**
   * 开票金额（含税）
   */
  @TableField("invoiceAmountWithTax")
  private BigDecimal invoiceAmountWithTax;

  /**
   * 付款公司
   */
  @TableField("paymentCompany")
  private String paymentCompany;

  /**
   * 本期优惠金额（含税）
   */
  @TableField("currentDiscountAmountWithTax")
  private BigDecimal currentDiscountAmountWithTax;

  /**
   * 回款日期
   */
  @TableField("payBackDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime payBackDate;

  /**
   * 回款金额
   */
  @TableField("payBackAmount")
  private BigDecimal payBackAmount;

  /**
   * 数据类型
   */
  @TableField("dataType")
  private String dataType;

  /**
   * 要核销余额-作废
   */
  @TableField("compensateAmount")
  private BigDecimal compensateAmount;

  /**
   * 本期优惠后应结算金额（含税）
   */
  @TableField("currentPayableAmountAfterDiscountWithTax")
  private BigDecimal currentPayableAmountAfterDiscountWithTax;

  /**
   * 本期优惠后应结算金额（不含税）
   */
  @TableField("currentPayableAmountAfterDiscountWithoutTax")
  private BigDecimal currentPayableAmountAfterDiscountWithoutTax;

  /**
   * 订单总金额
   */
  @TableField("orderTotalAmount")
  private BigDecimal orderTotalAmount;

  /**
   * 订单待核销金额
   */
  @TableField("orderWaitAmount")
  private BigDecimal orderWaitAmount;

  /**
   * 订单已核销金额
   */
  @TableField("orderReadyAmount")
  private BigDecimal orderReadyAmount;

  /**
   * 发票待核销金额
   */
  @TableField("invoiceWaitAmount")
  private BigDecimal invoiceWaitAmount;

  /**
   * 发票已核销金额
   */
  @TableField("invoiceReadyAmount")
  private BigDecimal invoiceReadyAmount;

  /**
   * 税号待核销金额
   */
  @TableField("taxWaitAmount")
  private BigDecimal taxWaitAmount;

  /**
   * 税号已核销金额
   */
  @TableField("taxReadyAmount")
  private BigDecimal taxReadyAmount;

  /**
   * 是否展示
   */
  @TableField("isShow")
  private Boolean isShow;

  /**
   * 流水索引
   */
  @TableField("indexTradeNo")
  private String indexTradeNo;

  /**
   * 流水分摊信息
   */
  @TableField("tradeShareInfo")
  private String tradeShareInfo;

  /**
   * 订单生成日期
   */
  @TableField("orderGenerateDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime orderGenerateDate;

  /**
   * 结算对账单编号
   */
  @TableField("billNo")
  private String billNo;

  /**
   * 产品服务名称
   */
  @TableField("productName")
  private String productName;

  /**
   * 本期折抵金额(含税)
   */
  @TableField("reducedAmountWithTax")
  private BigDecimal reducedAmountWithTax;

  /**
   * 设备编号
   */
  @TableField("deviceNo")
  private String deviceNo;

  /**
   * 设备类型
   */
  @TableField("deviceType")
  private String deviceType;

  /**
   * 是否有效
   */
  @TableField("whetherEffectiveOrNot")
  private String whetherEffectiveOrNot;

  /**
   * 验收时间
   */
  @TableField("acceptanceTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime acceptanceTime;

  /**
   * 项目分期名称
   */
  @TableField("projectItemName")
  private String projectItemName;

  /**
   * 项目分期编号
   */
  @TableField("projectItemCode")
  private String projectItemCode;

  /**
   * 渠道类型
   */
  @TableField("tenantType")
  private String tenantType;


  /**
   * 对一关联关系 关联对象 contract
   */
    private Long oneContractToManyBillStaticsDetailId;
  /**
   * 对一关联关系 关联对象 billStatics
   */
    private Long manySettlementDetailToOneSettlementMainId;
  /**
   * 对一关联关系 关联对象 billStatics
   */
    private Long oneSettlementMainToManySettlementDetailsId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("billDetailNo", billDetailNo);
      map.put("contractNo", contractNo);
      map.put("productNo", productNo);
      map.put("chargeType", chargeType);
      map.put("salePriceWithoutTax", salePriceWithoutTax);
      map.put("unitAmountWithoutTax", unitAmountWithoutTax);
      map.put("currentPayableAmountWithTax", currentPayableAmountWithTax);
      map.put("taxRate", taxRate);
      map.put("taxNo", taxNo);
      map.put("taxCompanyName", taxCompanyName);
      map.put("accountingStartDate", BocpGenUtils.toTimestamp(accountingStartDate));
      map.put("accountingEndDate", BocpGenUtils.toTimestamp(accountingEndDate));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("invoiceCode", invoiceCode);
      map.put("invoiceNo", invoiceNo);
      map.put("waitingAmount", waitingAmount);
      map.put("readyAmount", readyAmount);
      map.put("orderNo", orderNo);
      map.put("paymentType", paymentType);
      map.put("paymentRequirement", paymentRequirement);
      map.put("property", property);
      map.put("quantity", quantity);
      map.put("chargeUnit", chargeUnit);
      map.put("chargeDays", chargeDays);
      map.put("chargeCycle", chargeCycle);
      map.put("billCreateDate", BocpGenUtils.toTimestamp(billCreateDate));
      map.put("invoiceCompanyName", invoiceCompanyName);
      map.put("invoiceCompanyTaxNo", invoiceCompanyTaxNo);
      map.put("invoiceGenerateDate", BocpGenUtils.toTimestamp(invoiceGenerateDate));
      map.put("invoiceAmountWithoutTax", invoiceAmountWithoutTax);
      map.put("invoiceAmountWithTax", invoiceAmountWithTax);
      map.put("paymentCompany", paymentCompany);
      map.put("currentDiscountAmountWithTax", currentDiscountAmountWithTax);
      map.put("payBackDate", BocpGenUtils.toTimestamp(payBackDate));
      map.put("payBackAmount", payBackAmount);
      map.put("dataType", dataType);
      map.put("compensateAmount", compensateAmount);
      map.put("currentPayableAmountAfterDiscountWithTax", currentPayableAmountAfterDiscountWithTax);
      map.put("currentPayableAmountAfterDiscountWithoutTax", currentPayableAmountAfterDiscountWithoutTax);
      map.put("orderTotalAmount", orderTotalAmount);
      map.put("orderWaitAmount", orderWaitAmount);
      map.put("orderReadyAmount", orderReadyAmount);
      map.put("invoiceWaitAmount", invoiceWaitAmount);
      map.put("invoiceReadyAmount", invoiceReadyAmount);
      map.put("taxWaitAmount", taxWaitAmount);
      map.put("taxReadyAmount", taxReadyAmount);
      map.put("isShow", isShow);
      map.put("indexTradeNo", indexTradeNo);
      map.put("tradeShareInfo", tradeShareInfo);
      map.put("orderGenerateDate", BocpGenUtils.toTimestamp(orderGenerateDate));
      map.put("billNo", billNo);
      map.put("productName", productName);
      map.put("reducedAmountWithTax", reducedAmountWithTax);
      map.put("deviceNo", deviceNo);
      map.put("deviceType", deviceType);
      map.put("whetherEffectiveOrNot", whetherEffectiveOrNot);
      map.put("acceptanceTime", BocpGenUtils.toTimestamp(acceptanceTime));
      map.put("projectItemName", projectItemName);
      map.put("projectItemCode", projectItemCode);
      map.put("tenantType", tenantType);

       map.put("oneContractToManyBillStaticsDetail.id", oneContractToManyBillStaticsDetailId);
       map.put("manySettlementDetailToOneSettlementMain.id", manySettlementDetailToOneSettlementMainId);
       map.put("oneSettlementMainToManySettlementDetails.id", oneSettlementMainToManySettlementDetailsId);
      return map;
  }

  public static BillStaticsDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    BillStaticsDetail entity = new BillStaticsDetail();
    if(map.containsKey("billDetailNo")) {
      Object obj = map.get("billDetailNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillDetailNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productNo")) {
      Object obj = map.get("productNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeType")) {
      Object obj = map.get("chargeType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salePriceWithoutTax")) {
      Object obj = map.get("salePriceWithoutTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalePriceWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unitAmountWithoutTax")) {
      Object obj = map.get("unitAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnitAmountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currentPayableAmountWithTax")) {
      Object obj = map.get("currentPayableAmountWithTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCurrentPayableAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxNo")) {
      Object obj = map.get("taxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxCompanyName")) {
      Object obj = map.get("taxCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountingStartDate")) {
      Object obj = map.get("accountingStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountingStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setAccountingStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAccountingStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAccountingStartDate(null);
      }
    }
    if(map.containsKey("accountingEndDate")) {
      Object obj = map.get("accountingEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountingEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setAccountingEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAccountingEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAccountingEndDate(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("waitingAmount")) {
      Object obj = map.get("waitingAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setWaitingAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setWaitingAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setWaitingAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setWaitingAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setWaitingAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("readyAmount")) {
      Object obj = map.get("readyAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReadyAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReadyAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReadyAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReadyAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReadyAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("orderNo")) {
      Object obj = map.get("orderNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentType")) {
      Object obj = map.get("paymentType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentRequirement")) {
      Object obj = map.get("paymentRequirement");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentRequirement((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("property")) {
      Object obj = map.get("property");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProperty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("chargeUnit")) {
      Object obj = map.get("chargeUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeDays")) {
      Object obj = map.get("chargeDays");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChargeDays((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setChargeDays(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setChargeDays(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("chargeCycle")) {
      Object obj = map.get("chargeCycle");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeCycle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billCreateDate")) {
      Object obj = map.get("billCreateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBillCreateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setBillCreateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBillCreateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBillCreateDate(null);
      }
    }
    if(map.containsKey("invoiceCompanyName")) {
      Object obj = map.get("invoiceCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCompanyTaxNo")) {
      Object obj = map.get("invoiceCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceGenerateDate")) {
      Object obj = map.get("invoiceGenerateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceGenerateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setInvoiceGenerateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceGenerateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setInvoiceGenerateDate(null);
      }
    }
    if(map.containsKey("invoiceAmountWithoutTax")) {
      Object obj = map.get("invoiceAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAmountWithTax")) {
      Object obj = map.get("invoiceAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("paymentCompany")) {
      Object obj = map.get("paymentCompany");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentCompany((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currentDiscountAmountWithTax")) {
      Object obj = map.get("currentDiscountAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCurrentDiscountAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCurrentDiscountAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCurrentDiscountAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCurrentDiscountAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCurrentDiscountAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("payBackDate")) {
      Object obj = map.get("payBackDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPayBackDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPayBackDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayBackDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPayBackDate(null);
      }
    }
    if(map.containsKey("payBackAmount")) {
      Object obj = map.get("payBackAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPayBackAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPayBackAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPayBackAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayBackAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayBackAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("dataType")) {
      Object obj = map.get("dataType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("compensateAmount")) {
      Object obj = map.get("compensateAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCompensateAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCompensateAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCompensateAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCompensateAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCompensateAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("currentPayableAmountAfterDiscountWithTax")) {
      Object obj = map.get("currentPayableAmountAfterDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCurrentPayableAmountAfterDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCurrentPayableAmountAfterDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCurrentPayableAmountAfterDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCurrentPayableAmountAfterDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCurrentPayableAmountAfterDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("currentPayableAmountAfterDiscountWithoutTax")) {
      Object obj = map.get("currentPayableAmountAfterDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCurrentPayableAmountAfterDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCurrentPayableAmountAfterDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCurrentPayableAmountAfterDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCurrentPayableAmountAfterDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCurrentPayableAmountAfterDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("orderTotalAmount")) {
      Object obj = map.get("orderTotalAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOrderTotalAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOrderTotalAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOrderTotalAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderTotalAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderTotalAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("orderWaitAmount")) {
      Object obj = map.get("orderWaitAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOrderWaitAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOrderWaitAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOrderWaitAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderWaitAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderWaitAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("orderReadyAmount")) {
      Object obj = map.get("orderReadyAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOrderReadyAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOrderReadyAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOrderReadyAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderReadyAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderReadyAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceWaitAmount")) {
      Object obj = map.get("invoiceWaitAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceWaitAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceWaitAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceWaitAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceWaitAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceWaitAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceReadyAmount")) {
      Object obj = map.get("invoiceReadyAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceReadyAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceReadyAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceReadyAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceReadyAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceReadyAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxWaitAmount")) {
      Object obj = map.get("taxWaitAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxWaitAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxWaitAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxWaitAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxWaitAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxWaitAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxReadyAmount")) {
      Object obj = map.get("taxReadyAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxReadyAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxReadyAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxReadyAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxReadyAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxReadyAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("isShow")) {
      Object obj = map.get("isShow");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsShow((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsShow(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("indexTradeNo")) {
      Object obj = map.get("indexTradeNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIndexTradeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tradeShareInfo")) {
      Object obj = map.get("tradeShareInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTradeShareInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderGenerateDate")) {
      Object obj = map.get("orderGenerateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderGenerateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setOrderGenerateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderGenerateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOrderGenerateDate(null);
      }
    }
    if(map.containsKey("billNo")) {
      Object obj = map.get("billNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reducedAmountWithTax")) {
      Object obj = map.get("reducedAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReducedAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReducedAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReducedAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReducedAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReducedAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("deviceNo")) {
      Object obj = map.get("deviceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeviceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deviceType")) {
      Object obj = map.get("deviceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeviceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("whetherEffectiveOrNot")) {
      Object obj = map.get("whetherEffectiveOrNot");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWhetherEffectiveOrNot((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("acceptanceTime")) {
      Object obj = map.get("acceptanceTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAcceptanceTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setAcceptanceTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAcceptanceTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAcceptanceTime(null);
      }
    }
    if(map.containsKey("projectItemName")) {
      Object obj = map.get("projectItemName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectItemCode")) {
      Object obj = map.get("projectItemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenantType")) {
      Object obj = map.get("tenantType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantType((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("oneContractToManyBillStaticsDetail.id")) {
        Object obj = map.get("oneContractToManyBillStaticsDetail.id");
      if(obj instanceof Long) {
        entity.setOneContractToManyBillStaticsDetailId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setOneContractToManyBillStaticsDetailId(Long.parseLong((String)obj));
      }
    }
    if(map.containsKey("manySettlementDetailToOneSettlementMain.id")) {
        Object obj = map.get("manySettlementDetailToOneSettlementMain.id");
      if(obj instanceof Long) {
        entity.setManySettlementDetailToOneSettlementMainId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setManySettlementDetailToOneSettlementMainId(Long.parseLong((String)obj));
      }
    }
    if(map.containsKey("oneSettlementMainToManySettlementDetails.id")) {
        Object obj = map.get("oneSettlementMainToManySettlementDetails.id");
      if(obj instanceof Long) {
        entity.setOneSettlementMainToManySettlementDetailsId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setOneSettlementMainToManySettlementDetailsId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("billDetailNo")) {
      Object obj = map.get("billDetailNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillDetailNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setContractNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("productNo")) {
      Object obj = map.get("productNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProductNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chargeType")) {
      Object obj = map.get("chargeType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salePriceWithoutTax")) {
      Object obj = map.get("salePriceWithoutTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalePriceWithoutTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unitAmountWithoutTax")) {
      Object obj = map.get("unitAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnitAmountWithoutTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("currentPayableAmountWithTax")) {
      Object obj = map.get("currentPayableAmountWithTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCurrentPayableAmountWithTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxRate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxNo")) {
      Object obj = map.get("taxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxCompanyName")) {
      Object obj = map.get("taxCompanyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("accountingStartDate")) {
      Object obj = map.get("accountingStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAccountingStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setAccountingStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAccountingStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setAccountingStartDate(null);
      }
    }
    if(map.containsKey("accountingEndDate")) {
      Object obj = map.get("accountingEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAccountingEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setAccountingEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAccountingEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setAccountingEndDate(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("waitingAmount")) {
      Object obj = map.get("waitingAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setWaitingAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setWaitingAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setWaitingAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setWaitingAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setWaitingAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("readyAmount")) {
      Object obj = map.get("readyAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setReadyAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setReadyAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setReadyAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReadyAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setReadyAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("orderNo")) {
      Object obj = map.get("orderNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paymentType")) {
      Object obj = map.get("paymentType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paymentRequirement")) {
      Object obj = map.get("paymentRequirement");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentRequirement((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("property")) {
      Object obj = map.get("property");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProperty((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("chargeUnit")) {
      Object obj = map.get("chargeUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chargeDays")) {
      Object obj = map.get("chargeDays");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setChargeDays((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setChargeDays(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setChargeDays(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("chargeCycle")) {
      Object obj = map.get("chargeCycle");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeCycle((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billCreateDate")) {
      Object obj = map.get("billCreateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBillCreateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setBillCreateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBillCreateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setBillCreateDate(null);
      }
    }
    if(map.containsKey("invoiceCompanyName")) {
      Object obj = map.get("invoiceCompanyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceCompanyTaxNo")) {
      Object obj = map.get("invoiceCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceGenerateDate")) {
      Object obj = map.get("invoiceGenerateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setInvoiceGenerateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setInvoiceGenerateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceGenerateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setInvoiceGenerateDate(null);
      }
    }
    if(map.containsKey("invoiceAmountWithoutTax")) {
      Object obj = map.get("invoiceAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInvoiceAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInvoiceAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInvoiceAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoiceAmountWithTax")) {
      Object obj = map.get("invoiceAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInvoiceAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInvoiceAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInvoiceAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("paymentCompany")) {
      Object obj = map.get("paymentCompany");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentCompany((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("currentDiscountAmountWithTax")) {
      Object obj = map.get("currentDiscountAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCurrentDiscountAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCurrentDiscountAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCurrentDiscountAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCurrentDiscountAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCurrentDiscountAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("payBackDate")) {
      Object obj = map.get("payBackDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPayBackDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPayBackDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayBackDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPayBackDate(null);
      }
    }
    if(map.containsKey("payBackAmount")) {
      Object obj = map.get("payBackAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPayBackAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPayBackAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPayBackAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayBackAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPayBackAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("dataType")) {
      Object obj = map.get("dataType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDataType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("compensateAmount")) {
      Object obj = map.get("compensateAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCompensateAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCompensateAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCompensateAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCompensateAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCompensateAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("currentPayableAmountAfterDiscountWithTax")) {
      Object obj = map.get("currentPayableAmountAfterDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCurrentPayableAmountAfterDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCurrentPayableAmountAfterDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCurrentPayableAmountAfterDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCurrentPayableAmountAfterDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCurrentPayableAmountAfterDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("currentPayableAmountAfterDiscountWithoutTax")) {
      Object obj = map.get("currentPayableAmountAfterDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCurrentPayableAmountAfterDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCurrentPayableAmountAfterDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCurrentPayableAmountAfterDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCurrentPayableAmountAfterDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCurrentPayableAmountAfterDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("orderTotalAmount")) {
      Object obj = map.get("orderTotalAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOrderTotalAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOrderTotalAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOrderTotalAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderTotalAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrderTotalAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("orderWaitAmount")) {
      Object obj = map.get("orderWaitAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOrderWaitAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOrderWaitAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOrderWaitAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderWaitAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrderWaitAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("orderReadyAmount")) {
      Object obj = map.get("orderReadyAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOrderReadyAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOrderReadyAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOrderReadyAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderReadyAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrderReadyAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoiceWaitAmount")) {
      Object obj = map.get("invoiceWaitAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInvoiceWaitAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInvoiceWaitAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInvoiceWaitAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceWaitAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceWaitAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoiceReadyAmount")) {
      Object obj = map.get("invoiceReadyAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInvoiceReadyAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInvoiceReadyAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInvoiceReadyAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceReadyAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceReadyAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("taxWaitAmount")) {
      Object obj = map.get("taxWaitAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxWaitAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxWaitAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxWaitAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxWaitAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxWaitAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("taxReadyAmount")) {
      Object obj = map.get("taxReadyAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxReadyAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxReadyAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxReadyAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxReadyAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxReadyAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("isShow")) {
      Object obj = map.get("isShow");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setIsShow((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setIsShow(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("indexTradeNo")) {
      Object obj = map.get("indexTradeNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIndexTradeNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tradeShareInfo")) {
      Object obj = map.get("tradeShareInfo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTradeShareInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderGenerateDate")) {
      Object obj = map.get("orderGenerateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOrderGenerateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setOrderGenerateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderGenerateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setOrderGenerateDate(null);
      }
    }
    if(map.containsKey("billNo")) {
      Object obj = map.get("billNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProductName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reducedAmountWithTax")) {
      Object obj = map.get("reducedAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setReducedAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setReducedAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setReducedAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReducedAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setReducedAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("deviceNo")) {
      Object obj = map.get("deviceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeviceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deviceType")) {
      Object obj = map.get("deviceType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeviceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("whetherEffectiveOrNot")) {
      Object obj = map.get("whetherEffectiveOrNot");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWhetherEffectiveOrNot((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("acceptanceTime")) {
      Object obj = map.get("acceptanceTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAcceptanceTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setAcceptanceTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAcceptanceTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setAcceptanceTime(null);
      }
    }
    if(map.containsKey("projectItemName")) {
      Object obj = map.get("projectItemName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProjectItemName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("projectItemCode")) {
      Object obj = map.get("projectItemCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProjectItemCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tenantType")) {
      Object obj = map.get("tenantType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantType((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("oneContractToManyBillStaticsDetail.id")) {
        Object obj = map.get("oneContractToManyBillStaticsDetail.id");
        if(obj instanceof Long) {
          this.setOneContractToManyBillStaticsDetailId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOneContractToManyBillStaticsDetailId(Long.parseLong((String)obj));
        }
      }
      if(map.containsKey("manySettlementDetailToOneSettlementMain.id")) {
        Object obj = map.get("manySettlementDetailToOneSettlementMain.id");
        if(obj instanceof Long) {
          this.setManySettlementDetailToOneSettlementMainId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setManySettlementDetailToOneSettlementMainId(Long.parseLong((String)obj));
        }
      }
      if(map.containsKey("oneSettlementMainToManySettlementDetails.id")) {
        Object obj = map.get("oneSettlementMainToManySettlementDetails.id");
        if(obj instanceof Long) {
          this.setOneSettlementMainToManySettlementDetailsId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOneSettlementMainToManySettlementDetailsId(Long.parseLong((String)obj));
        }
      }
  }
}
