package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-11-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class FkjInvoiceBillImageRelation implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 单据编号
   */
  @TableField("billNo")
  private String billNo;

  /**
   * 发票号码
   */
  @TableField("invoiceNo")
  private String invoiceNo;

  /**
   * 发票代码
   */
  @TableField("invoiceCode")
  private String invoiceCode;

  /**
   * 销方公司名称
   */
  @TableField("sellerCompanyName")
  private String sellerCompanyName;

  /**
   * 销方纳税人识别号
   */
  @TableField("sellerIdentityNumber")
  private String sellerIdentityNumber;

  /**
   * 开票日期
   */
  @TableField("invoiceOpenDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime invoiceOpenDate;

  /**
   * 开票金额
   */
  @TableField("invoiceOpenAmount")
  private BigDecimal invoiceOpenAmount;

  /**
   * 单据提交人
   */
  @TableField("sumbitUser")
  private String sumbitUser;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 附件地址
   */
  @TableField("imageUrl")
  private String imageUrl;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("billNo", billNo);
      map.put("invoiceNo", invoiceNo);
      map.put("invoiceCode", invoiceCode);
      map.put("sellerCompanyName", sellerCompanyName);
      map.put("sellerIdentityNumber", sellerIdentityNumber);
      map.put("invoiceOpenDate", BocpGenUtils.toTimestamp(invoiceOpenDate));
      map.put("invoiceOpenAmount", invoiceOpenAmount);
      map.put("sumbitUser", sumbitUser);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("imageUrl", imageUrl);

      return map;
  }

  public static FkjInvoiceBillImageRelation fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    FkjInvoiceBillImageRelation entity = new FkjInvoiceBillImageRelation();
    if(map.containsKey("billNo")) {
      Object obj = map.get("billNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyName")) {
      Object obj = map.get("sellerCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerIdentityNumber")) {
      Object obj = map.get("sellerIdentityNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerIdentityNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceOpenDate")) {
      Object obj = map.get("invoiceOpenDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceOpenDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setInvoiceOpenDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceOpenDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setInvoiceOpenDate(null);
      }
    }
    if(map.containsKey("invoiceOpenAmount")) {
      Object obj = map.get("invoiceOpenAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceOpenAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceOpenAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceOpenAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceOpenAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceOpenAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sumbitUser")) {
      Object obj = map.get("sumbitUser");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSumbitUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("imageUrl")) {
      Object obj = map.get("imageUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setImageUrl((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("billNo")) {
      Object obj = map.get("billNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerCompanyName")) {
      Object obj = map.get("sellerCompanyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerIdentityNumber")) {
      Object obj = map.get("sellerIdentityNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerIdentityNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceOpenDate")) {
      Object obj = map.get("invoiceOpenDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setInvoiceOpenDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setInvoiceOpenDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceOpenDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setInvoiceOpenDate(null);
      }
    }
    if(map.containsKey("invoiceOpenAmount")) {
      Object obj = map.get("invoiceOpenAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInvoiceOpenAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInvoiceOpenAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInvoiceOpenAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceOpenAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceOpenAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sumbitUser")) {
      Object obj = map.get("sumbitUser");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSumbitUser((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("imageUrl")) {
      Object obj = map.get("imageUrl");
      if(obj != null) {
        if(obj instanceof String) {
          this.setImageUrl((String)obj);
        }
      } else {
      }
    }
  }
}
