package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-11-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class NbBankTradeDetail implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 账号
   */
  @TableField("bankAcc")
  private String bankAcc;

  /**
   * 开户行名
   */
  @TableField("bankName")
  private String bankName;

  /**
   * 户名
   */
  @TableField("accName")
  private String accName;

  /**
   * 对方户名
   */
  @TableField("oppAccName")
  private String oppAccName;

  /**
   * 对方账号
   */
  @TableField("oppAccNo")
  private String oppAccNo;

  /**
   * 对方开户行名
   */
  @TableField("oppAccBank")
  private String oppAccBank;

  /**
   * 收支枚举
   */
  @TableField("cdSign")
  private String cdSign;

  /**
   * 交易金额
   */
  private BigDecimal amt;

  /**
   * 明细余额
   */
  private BigDecimal bal;

  /**
   * 时间
   */
  @TableField("transTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime transTime;

  /**
   * 交易流水号
   */
  @TableField("serialNo")
  private String serialNo;

  /**
   * 子流水号
   */
  @TableField("subSerialNo")
  private String subSerialNo;

  /**
   * 币种编号
   */
  @TableField("curCode")
  private String curCode;

  /**
   * 业务类型
   */
  @TableField("cdSignName")
  private String cdSignName;

  /**
   * 用途
   */
  private String uses;

  /**
   * 摘要
   */
  private String abs;

  /**
   * 回单编号
   */
  @TableField("voucherNo")
  private String voucherNo;

  /**
   * 银行类别代码
   */
  @TableField("bifCode")
  private String bifCode;

  /**
   * 银行类别
   */
  @TableField("bankType")
  private String bankType;

  /**
   * 对方银行类别
   */
  @TableField("oppBankType")
  private String oppBankType;

  /**
   * 对公对私枚举
   */
  @TableField("isForIndividual")
  private String isForIndividual;

  /**
   * 流水号PK
   */
  @TableField("serialId")
  private String serialId;

  /**
   * 银行流水号
   */
  @TableField("bankserailId")
  private String bankserailId;

  /**
   * 集团内交易
   */
  @TableField("groupTrans")
  private String groupTrans;

  /**
   * 资金划拨
   */
  @TableField("capitalTrans")
  private String capitalTrans;

  /**
   * 交易备注
   */
  @TableField("postScript")
  private String postScript;

  /**
   * 现转标识
   */
  @TableField("cashTfrFlg")
  private String cashTfrFlg;

  /**
   * 国开行所属分行号
   */
  @TableField("chinaDevelopBankNo")
  private String chinaDevelopBankNo;

  /**
   * 国开行所属账号类型
   */
  @TableField("chinaDevelopAccType")
  private String chinaDevelopAccType;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("bankAcc", bankAcc);
      map.put("bankName", bankName);
      map.put("accName", accName);
      map.put("oppAccName", oppAccName);
      map.put("oppAccNo", oppAccNo);
      map.put("oppAccBank", oppAccBank);
      map.put("cdSign", cdSign);
      map.put("amt", amt);
      map.put("bal", bal);
      map.put("transTime", BocpGenUtils.toTimestamp(transTime));
      map.put("serialNo", serialNo);
      map.put("subSerialNo", subSerialNo);
      map.put("curCode", curCode);
      map.put("cdSignName", cdSignName);
      map.put("uses", uses);
      map.put("abs", abs);
      map.put("voucherNo", voucherNo);
      map.put("bifCode", bifCode);
      map.put("bankType", bankType);
      map.put("oppBankType", oppBankType);
      map.put("isForIndividual", isForIndividual);
      map.put("serialId", serialId);
      map.put("bankserailId", bankserailId);
      map.put("groupTrans", groupTrans);
      map.put("capitalTrans", capitalTrans);
      map.put("postScript", postScript);
      map.put("cashTfrFlg", cashTfrFlg);
      map.put("chinaDevelopBankNo", chinaDevelopBankNo);
      map.put("chinaDevelopAccType", chinaDevelopAccType);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static NbBankTradeDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    NbBankTradeDetail entity = new NbBankTradeDetail();
    if(map.containsKey("bankAcc")) {
      Object obj = map.get("bankAcc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBankAcc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bankName")) {
      Object obj = map.get("bankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accName")) {
      Object obj = map.get("accName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oppAccName")) {
      Object obj = map.get("oppAccName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOppAccName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oppAccNo")) {
      Object obj = map.get("oppAccNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOppAccNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oppAccBank")) {
      Object obj = map.get("oppAccBank");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOppAccBank((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cdSign")) {
      Object obj = map.get("cdSign");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCdSign((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amt")) {
      Object obj = map.get("amt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bal")) {
      Object obj = map.get("bal");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("transTime")) {
      Object obj = map.get("transTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTransTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setTransTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTransTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTransTime(null);
      }
    }
    if(map.containsKey("serialNo")) {
      Object obj = map.get("serialNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSerialNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subSerialNo")) {
      Object obj = map.get("subSerialNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSubSerialNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("curCode")) {
      Object obj = map.get("curCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCurCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cdSignName")) {
      Object obj = map.get("cdSignName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCdSignName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("uses")) {
      Object obj = map.get("uses");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUses((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("abs")) {
      Object obj = map.get("abs");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAbs((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("voucherNo")) {
      Object obj = map.get("voucherNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVoucherNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bifCode")) {
      Object obj = map.get("bifCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBifCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bankType")) {
      Object obj = map.get("bankType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBankType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oppBankType")) {
      Object obj = map.get("oppBankType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOppBankType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isForIndividual")) {
      Object obj = map.get("isForIndividual");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsForIndividual((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serialId")) {
      Object obj = map.get("serialId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSerialId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bankserailId")) {
      Object obj = map.get("bankserailId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBankserailId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("groupTrans")) {
      Object obj = map.get("groupTrans");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGroupTrans((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("capitalTrans")) {
      Object obj = map.get("capitalTrans");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCapitalTrans((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("postScript")) {
      Object obj = map.get("postScript");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPostScript((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cashTfrFlg")) {
      Object obj = map.get("cashTfrFlg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCashTfrFlg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chinaDevelopBankNo")) {
      Object obj = map.get("chinaDevelopBankNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChinaDevelopBankNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chinaDevelopAccType")) {
      Object obj = map.get("chinaDevelopAccType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChinaDevelopAccType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("bankAcc")) {
      Object obj = map.get("bankAcc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBankAcc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bankName")) {
      Object obj = map.get("bankName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("accName")) {
      Object obj = map.get("accName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("oppAccName")) {
      Object obj = map.get("oppAccName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOppAccName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("oppAccNo")) {
      Object obj = map.get("oppAccNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOppAccNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("oppAccBank")) {
      Object obj = map.get("oppAccBank");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOppAccBank((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cdSign")) {
      Object obj = map.get("cdSign");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCdSign((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amt")) {
      Object obj = map.get("amt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("bal")) {
      Object obj = map.get("bal");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("transTime")) {
      Object obj = map.get("transTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTransTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setTransTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTransTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setTransTime(null);
      }
    }
    if(map.containsKey("serialNo")) {
      Object obj = map.get("serialNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSerialNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("subSerialNo")) {
      Object obj = map.get("subSerialNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSubSerialNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("curCode")) {
      Object obj = map.get("curCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCurCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cdSignName")) {
      Object obj = map.get("cdSignName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCdSignName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("uses")) {
      Object obj = map.get("uses");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUses((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("abs")) {
      Object obj = map.get("abs");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAbs((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("voucherNo")) {
      Object obj = map.get("voucherNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVoucherNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bifCode")) {
      Object obj = map.get("bifCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBifCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bankType")) {
      Object obj = map.get("bankType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBankType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("oppBankType")) {
      Object obj = map.get("oppBankType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOppBankType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isForIndividual")) {
      Object obj = map.get("isForIndividual");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsForIndividual((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("serialId")) {
      Object obj = map.get("serialId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSerialId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bankserailId")) {
      Object obj = map.get("bankserailId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBankserailId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("groupTrans")) {
      Object obj = map.get("groupTrans");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGroupTrans((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("capitalTrans")) {
      Object obj = map.get("capitalTrans");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCapitalTrans((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("postScript")) {
      Object obj = map.get("postScript");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPostScript((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cashTfrFlg")) {
      Object obj = map.get("cashTfrFlg");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCashTfrFlg((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chinaDevelopBankNo")) {
      Object obj = map.get("chinaDevelopBankNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChinaDevelopBankNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chinaDevelopAccType")) {
      Object obj = map.get("chinaDevelopAccType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChinaDevelopAccType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
