package com.xforceplus.ultraman.app.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * charge_code_relation_enum
 * </p>
 *
 * @author ultraman
 * @since 2023-12-26
 */
public enum ChargeCodeRelationEnum {

    YKB("YKB", "易快报");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ChargeCodeRelationEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChargeCodeRelationEnum fromCode(String code){
        switch(code) {
            case "YKB":
                return YKB;
            default:
                return null;
        }
    }
}
