package com.xforceplus.ultraman.app.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * financifal_budget_type
 * </p>
 *
 * @author ultraman
 * @since 2023-12-26
 */
public enum FinancifalBudgetType {

    _1("1", "项目管理人工成本"),
    _2("2", "项目管理差旅预算"),
    _3("3", "项目管理客情预算"),
    _4("4", "交付实施人工成本"),
    _5("5", "交付实施差旅预算"),
    _6("6", "运维预算"),
    _7("7", "超级/高级支持服务预算"),
    _8("8", "交付实施客情预算"),
    D001("D001", "部门-差旅费"),
    D002("D002", "部门-业务招待费"),
    D003("D003", "部门-行政办公费"),
    D004("D004", "部门-房租物业"),
    D005("D005", "部门-福利费"),
    D006("D006", "部门-团建活动费"),
    D007("D007", "部门-计算机及相关办公设备"),
    D008("D008", "部门-培训会议费"),
    D009("D009", "部门-云资通道及托管服务"),
    D010("D010", "部门-市场服务费"),
    D011("D011", "部门-综合服务费"),
    D012("D012", "部门-其他产品服务费"),
    D013("D013", "部门-差旅相关平台充值");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    FinancifalBudgetType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FinancifalBudgetType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "D001":
                return D001;
            case "D002":
                return D002;
            case "D003":
                return D003;
            case "D004":
                return D004;
            case "D005":
                return D005;
            case "D006":
                return D006;
            case "D007":
                return D007;
            case "D008":
                return D008;
            case "D009":
                return D009;
            case "D010":
                return D010;
            case "D011":
                return D011;
            case "D012":
                return D012;
            case "D013":
                return D013;
            default:
                return null;
        }
    }
}
