package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-12-26
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class CapitalVerifyRuleItemConfig implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 右字段值
   */
  @TableField("rightFieldValue")
  private String rightFieldValue;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 左对象描述
   */
  @TableField("leftModelText")
  private String leftModelText;

  /**
   * 左对象值
   */
  @TableField("leftModelValue")
  private String leftModelValue;

  /**
   * 左字段描述
   */
  @TableField("leftFieldText")
  private String leftFieldText;

  /**
   * 左字段值
   */
  @TableField("leftFieldValue")
  private String leftFieldValue;

  /**
   * 操作符描述
   */
  @TableField("operatorText")
  private String operatorText;

  /**
   * 操作符值
   */
  @TableField("operatorValue")
  private String operatorValue;

  /**
   * 右对象描述
   */
  @TableField("rightModelText")
  private String rightModelText;

  /**
   * 右对象值
   */
  @TableField("rightModelValue")
  private String rightModelValue;

  /**
   * 右字段描述
   */
  @TableField("rightFieldText")
  private String rightFieldText;

  /**
   * 固定值
   */
  @TableField("fixValue")
  private String fixValue;

  /**
   * 是否启用
   */
  private Boolean valid;

  /**
   * 左字段类型
   */
  @TableField("leftFieldType")
  private String leftFieldType;

  /**
   * 右字段类型
   */
  @TableField("rightFieldType")
  private String rightFieldType;

  /**
   * 固定值描述
   */
  @TableField("fixText")
  private String fixText;


  /**
   * 对一关联关系 关联对象 capitalVerifyRuleConfig
   */
    private Long capitalVerifyRuleRefId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("rightFieldValue", rightFieldValue);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("leftModelText", leftModelText);
      map.put("leftModelValue", leftModelValue);
      map.put("leftFieldText", leftFieldText);
      map.put("leftFieldValue", leftFieldValue);
      map.put("operatorText", operatorText);
      map.put("operatorValue", operatorValue);
      map.put("rightModelText", rightModelText);
      map.put("rightModelValue", rightModelValue);
      map.put("rightFieldText", rightFieldText);
      map.put("fixValue", fixValue);
      map.put("valid", valid);
      map.put("leftFieldType", leftFieldType);
      map.put("rightFieldType", rightFieldType);
      map.put("fixText", fixText);

       map.put("capitalVerifyRuleRef.id", capitalVerifyRuleRefId);
      return map;
  }

  public static CapitalVerifyRuleItemConfig fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    CapitalVerifyRuleItemConfig entity = new CapitalVerifyRuleItemConfig();
    if(map.containsKey("rightFieldValue")) {
      Object obj = map.get("rightFieldValue");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRightFieldValue((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("leftModelText")) {
      Object obj = map.get("leftModelText");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLeftModelText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("leftModelValue")) {
      Object obj = map.get("leftModelValue");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLeftModelValue((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("leftFieldText")) {
      Object obj = map.get("leftFieldText");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLeftFieldText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("leftFieldValue")) {
      Object obj = map.get("leftFieldValue");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLeftFieldValue((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("operatorText")) {
      Object obj = map.get("operatorText");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOperatorText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("operatorValue")) {
      Object obj = map.get("operatorValue");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOperatorValue((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rightModelText")) {
      Object obj = map.get("rightModelText");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRightModelText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rightModelValue")) {
      Object obj = map.get("rightModelValue");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRightModelValue((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rightFieldText")) {
      Object obj = map.get("rightFieldText");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRightFieldText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fixValue")) {
      Object obj = map.get("fixValue");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFixValue((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("valid")) {
      Object obj = map.get("valid");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setValid((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setValid(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("leftFieldType")) {
      Object obj = map.get("leftFieldType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLeftFieldType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rightFieldType")) {
      Object obj = map.get("rightFieldType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRightFieldType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fixText")) {
      Object obj = map.get("fixText");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFixText((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("capitalVerifyRuleRef.id")) {
        Object obj = map.get("capitalVerifyRuleRef.id");
      if(obj instanceof Long) {
        entity.setCapitalVerifyRuleRefId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setCapitalVerifyRuleRefId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("rightFieldValue")) {
      Object obj = map.get("rightFieldValue");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRightFieldValue((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("leftModelText")) {
      Object obj = map.get("leftModelText");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLeftModelText((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("leftModelValue")) {
      Object obj = map.get("leftModelValue");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLeftModelValue((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("leftFieldText")) {
      Object obj = map.get("leftFieldText");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLeftFieldText((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("leftFieldValue")) {
      Object obj = map.get("leftFieldValue");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLeftFieldValue((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("operatorText")) {
      Object obj = map.get("operatorText");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOperatorText((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("operatorValue")) {
      Object obj = map.get("operatorValue");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOperatorValue((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rightModelText")) {
      Object obj = map.get("rightModelText");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRightModelText((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rightModelValue")) {
      Object obj = map.get("rightModelValue");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRightModelValue((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rightFieldText")) {
      Object obj = map.get("rightFieldText");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRightFieldText((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("fixValue")) {
      Object obj = map.get("fixValue");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFixValue((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("valid")) {
      Object obj = map.get("valid");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setValid((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setValid(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("leftFieldType")) {
      Object obj = map.get("leftFieldType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLeftFieldType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rightFieldType")) {
      Object obj = map.get("rightFieldType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRightFieldType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("fixText")) {
      Object obj = map.get("fixText");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFixText((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("capitalVerifyRuleRef.id")) {
        Object obj = map.get("capitalVerifyRuleRef.id");
        if(obj instanceof Long) {
          this.setCapitalVerifyRuleRefId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCapitalVerifyRuleRefId(Long.parseLong((String)obj));
        }
      }
  }
}
