package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-12-26
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class DdRiverOrder implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 下单人姓名
   */
  private String employeeName;

  /**
   * 下单人员工号
   */
  private String employeeNumber;

  /**
   * 下单人邮箱
   */
  private String employeeEmail;

  /**
   * 支付方式
   */
  private String payType;

  /**
   * 订单总金额
   */
  private BigDecimal totalPrice;

  /**
   * 企业实付金额
   */
  private BigDecimal companyRealPay;

  /**
   * 个人实付金额
   */
  private BigDecimal personalRealPay;

  /**
   * 开始计费时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime beginChargeTime;

  /**
   * 结束计费时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime finishTime;

  /**
   * 支付时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime payTime;

  /**
   * 成本中心名称
   */
  private String chargeName;

  /**
   * 成本中心编码
   */
  private String chargeCode;

  /**
   * 用车备注
   */
  private String remark;

  /**
   * 补充说明
   */
  private String extRemark;

  /**
   * 行后审批结果
   */
  private String approvalStatus;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 下单人手机
   */
  private String employeePhone;

  /**
   * 乘车人手机号
   */
  private String passengerPhone;

  /**
   * 乘车人名字
   */
  private String passengerName;

  /**
   * 滴滴订单ID
   */
  private String ddOrderId;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("employee_name", employeeName);
      map.put("employee_number", employeeNumber);
      map.put("employee_email", employeeEmail);
      map.put("pay_type", payType);
      map.put("total_price", totalPrice);
      map.put("company_real_pay", companyRealPay);
      map.put("personal_real_pay", personalRealPay);
      map.put("begin_charge_time", BocpGenUtils.toTimestamp(beginChargeTime));
      map.put("finish_time", BocpGenUtils.toTimestamp(finishTime));
      map.put("pay_time", BocpGenUtils.toTimestamp(payTime));
      map.put("charge_name", chargeName);
      map.put("charge_code", chargeCode);
      map.put("remark", remark);
      map.put("ext_remark", extRemark);
      map.put("approval_status", approvalStatus);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("employee_phone", employeePhone);
      map.put("passenger_phone", passengerPhone);
      map.put("passenger_name", passengerName);
      map.put("dd_order_id", ddOrderId);

      return map;
  }

  public static DdRiverOrder fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    DdRiverOrder entity = new DdRiverOrder();
    if(map.containsKey("employee_name")) {
      Object obj = map.get("employee_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEmployeeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("employee_number")) {
      Object obj = map.get("employee_number");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEmployeeNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("employee_email")) {
      Object obj = map.get("employee_email");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEmployeeEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_type")) {
      Object obj = map.get("pay_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("total_price")) {
      Object obj = map.get("total_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("company_real_pay")) {
      Object obj = map.get("company_real_pay");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCompanyRealPay((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCompanyRealPay(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCompanyRealPay(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCompanyRealPay(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCompanyRealPay(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("personal_real_pay")) {
      Object obj = map.get("personal_real_pay");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPersonalRealPay((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPersonalRealPay(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPersonalRealPay(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPersonalRealPay(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPersonalRealPay(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("begin_charge_time")) {
      Object obj = map.get("begin_charge_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBeginChargeTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setBeginChargeTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBeginChargeTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBeginChargeTime(null);
      }
    }
    if(map.containsKey("finish_time")) {
      Object obj = map.get("finish_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFinishTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setFinishTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFinishTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setFinishTime(null);
      }
    }
    if(map.containsKey("pay_time")) {
      Object obj = map.get("pay_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPayTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPayTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPayTime(null);
      }
    }
    if(map.containsKey("charge_name")) {
      Object obj = map.get("charge_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_code")) {
      Object obj = map.get("charge_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext_remark")) {
      Object obj = map.get("ext_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approval_status")) {
      Object obj = map.get("approval_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApprovalStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("employee_phone")) {
      Object obj = map.get("employee_phone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEmployeePhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("passenger_phone")) {
      Object obj = map.get("passenger_phone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPassengerPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("passenger_name")) {
      Object obj = map.get("passenger_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPassengerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dd_order_id")) {
      Object obj = map.get("dd_order_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDdOrderId((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("employee_name")) {
      Object obj = map.get("employee_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEmployeeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("employee_number")) {
      Object obj = map.get("employee_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEmployeeNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("employee_email")) {
      Object obj = map.get("employee_email");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEmployeeEmail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_type")) {
      Object obj = map.get("pay_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("total_price")) {
      Object obj = map.get("total_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotalPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("company_real_pay")) {
      Object obj = map.get("company_real_pay");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCompanyRealPay((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCompanyRealPay(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCompanyRealPay(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCompanyRealPay(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCompanyRealPay(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("personal_real_pay")) {
      Object obj = map.get("personal_real_pay");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPersonalRealPay((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPersonalRealPay(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPersonalRealPay(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPersonalRealPay(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPersonalRealPay(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("begin_charge_time")) {
      Object obj = map.get("begin_charge_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBeginChargeTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setBeginChargeTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBeginChargeTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setBeginChargeTime(null);
      }
    }
    if(map.containsKey("finish_time")) {
      Object obj = map.get("finish_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setFinishTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setFinishTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setFinishTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setFinishTime(null);
      }
    }
    if(map.containsKey("pay_time")) {
      Object obj = map.get("pay_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPayTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPayTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPayTime(null);
      }
    }
    if(map.containsKey("charge_name")) {
      Object obj = map.get("charge_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("charge_code")) {
      Object obj = map.get("charge_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext_remark")) {
      Object obj = map.get("ext_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("approval_status")) {
      Object obj = map.get("approval_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApprovalStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("employee_phone")) {
      Object obj = map.get("employee_phone");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEmployeePhone((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("passenger_phone")) {
      Object obj = map.get("passenger_phone");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPassengerPhone((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("passenger_name")) {
      Object obj = map.get("passenger_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPassengerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dd_order_id")) {
      Object obj = map.get("dd_order_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDdOrderId((String)obj);
        }
      } else {
      }
    }
  }
}
