package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialApplyBasicBill;

/**
 * <p>
 * 资产的领用及更换申请单
 * </p>
 *
 * @author ultraman
 * @since 2023-12-26
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class FinancialAssetsBill extends FinancialApplyBasicBill {


  /**
   * 描述
   */
  private String describe;

  /**
   * 资产大类编码
   */
  @TableField("assetCategoriesCode")
  private String assetCategoriesCode;

  /**
   * 资产大类名称
   */
  @TableField("assetCategoriesName")
  private String assetCategoriesName;

  /**
   * 领用或更换地点编码
   */
  @TableField("assetsRegionalCode")
  private String assetsRegionalCode;

  /**
   * 领用或更换地点名称
   */
  @TableField("assetsRegionalName")
  private String assetsRegionalName;

  /**
   * 模板名称编码
   */
  @TableField("templateCode")
  private String templateCode;

  /**
   * 模板名称名称
   */
  @TableField("templateName")
  private String templateName;

  /**
   * 申请部门
   */
  @TableField("applicationDept")
  private String applicationDept;

  /**
   * 申请原因
   */
  private String cause;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("describe", describe);
      map.put("assetCategoriesCode", assetCategoriesCode);
      map.put("assetCategoriesName", assetCategoriesName);
      map.put("assetsRegionalCode", assetsRegionalCode);
      map.put("assetsRegionalName", assetsRegionalName);
      map.put("templateCode", templateCode);
      map.put("templateName", templateName);
      map.put("applicationDept", applicationDept);
      map.put("cause", cause);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static FinancialAssetsBill fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    FinancialAssetsBill entity = new FinancialAssetsBill();
    entity.setParentByOQSMap(map);
    if(map.containsKey("describe")) {
      Object obj = map.get("describe");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDescribe((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("assetCategoriesCode")) {
      Object obj = map.get("assetCategoriesCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAssetCategoriesCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("assetCategoriesName")) {
      Object obj = map.get("assetCategoriesName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAssetCategoriesName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("assetsRegionalCode")) {
      Object obj = map.get("assetsRegionalCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAssetsRegionalCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("assetsRegionalName")) {
      Object obj = map.get("assetsRegionalName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAssetsRegionalName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("templateCode")) {
      Object obj = map.get("templateCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTemplateCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("templateName")) {
      Object obj = map.get("templateName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTemplateName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applicationDept")) {
      Object obj = map.get("applicationDept");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplicationDept((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cause")) {
      Object obj = map.get("cause");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCause((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }

  protected void setParentByOQSMap(Map map) {
    super.setByOQSMap(map);
  }

  protected void setByOQSMap(Map map) {
    super.setByOQSMap(map);
    if(map.containsKey("describe")) {
      Object obj = map.get("describe");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDescribe((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("assetCategoriesCode")) {
      Object obj = map.get("assetCategoriesCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAssetCategoriesCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("assetCategoriesName")) {
      Object obj = map.get("assetCategoriesName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAssetCategoriesName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("assetsRegionalCode")) {
      Object obj = map.get("assetsRegionalCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAssetsRegionalCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("assetsRegionalName")) {
      Object obj = map.get("assetsRegionalName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAssetsRegionalName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("templateCode")) {
      Object obj = map.get("templateCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTemplateCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("templateName")) {
      Object obj = map.get("templateName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTemplateName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applicationDept")) {
      Object obj = map.get("applicationDept");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplicationDept((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cause")) {
      Object obj = map.get("cause");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCause((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
