package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 对账单明细-(废弃)
 * </p>
 *
 * @author ultraman
 * @since 2023-12-26
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ReconciliationDetailData implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 合同号
   */
  @TableField("contractNo")
  private String contractNo;

  /**
   * 租户
   */
  @TableField("tenantName")
  private String tenantName;

  /**
   * 产品名称
   */
  @TableField("productName")
  private String productName;

  /**
   * 结算周期开始时间
   */
  @TableField("chargeStartDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime chargeStartDate;

  /**
   * 结算周期结束时间
   */
  @TableField("chargeEndDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime chargeEndDate;

  /**
   * 付费方式
   */
  @TableField("chargeType")
  private String chargeType;

  /**
   * 应付金额
   */
  @TableField("payableAmount")
  private BigDecimal payableAmount;

  /**
   * 优惠金额
   */
  @TableField("discountMoney")
  private BigDecimal discountMoney;

  /**
   * 数量
   */
  private BigDecimal amount;

  /**
   * 结算对账子单号
   */
  @TableField("reconciliationDetailCode")
  private String reconciliationDetailCode;

  /**
   * 项目编号
   */
  @TableField("projectNo")
  private String projectNo;

  /**
   * 税号
   */
  @TableField("taxNo")
  private String taxNo;

  /**
   * 公司名称
   */
  @TableField("companyName")
  private String companyName;

  /**
   * 公司ID
   */
  @TableField("companyID")
  private String companyID;

  /**
   * 计费类型
   */
  @TableField("billingType")
  private String billingType;

  /**
   * 单价
   */
  @TableField("unitPriceWithoutTax")
  private BigDecimal unitPriceWithoutTax;

  /**
   * 税率
   */
  @TableField("taxRate")
  private BigDecimal taxRate;

  /**
   * id
   */
  private Long id;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 结算对账主单号
   */
  @TableField("reconciliationCode")
  private String reconciliationCode;

  /**
   * 结算单生成日期
   */
  @TableField("reconciliationCreateTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime reconciliationCreateTime;

  /**
   * 产品Code
   */
  @TableField("productCode")
  private String productCode;

  /**
   * 结算金额
   */
  @TableField("reconciliationSettleAccounts")
  private BigDecimal reconciliationSettleAccounts;

  /**
   * 一次性单位(系统)
   */
  @TableField("oneTimeUnit")
  private String oneTimeUnit;

  /**
   * 结算周期
   */
  @TableField("chargeCycle")
  private String chargeCycle;

  /**
   * 结算金额
   */
  @TableField("settlementAmount")
  private BigDecimal settlementAmount;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("contractNo", contractNo);
      map.put("tenantName", tenantName);
      map.put("productName", productName);
      map.put("chargeStartDate", BocpGenUtils.toTimestamp(chargeStartDate));
      map.put("chargeEndDate", BocpGenUtils.toTimestamp(chargeEndDate));
      map.put("chargeType", chargeType);
      map.put("payableAmount", payableAmount);
      map.put("discountMoney", discountMoney);
      map.put("amount", amount);
      map.put("reconciliationDetailCode", reconciliationDetailCode);
      map.put("projectNo", projectNo);
      map.put("taxNo", taxNo);
      map.put("companyName", companyName);
      map.put("companyID", companyID);
      map.put("billingType", billingType);
      map.put("unitPriceWithoutTax", unitPriceWithoutTax);
      map.put("taxRate", taxRate);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("reconciliationCode", reconciliationCode);
      map.put("reconciliationCreateTime", BocpGenUtils.toTimestamp(reconciliationCreateTime));
      map.put("productCode", productCode);
      map.put("reconciliationSettleAccounts", reconciliationSettleAccounts);
      map.put("oneTimeUnit", oneTimeUnit);
      map.put("chargeCycle", chargeCycle);
      map.put("settlementAmount", settlementAmount);

      return map;
  }

  public static ReconciliationDetailData fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ReconciliationDetailData entity = new ReconciliationDetailData();
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenantName")) {
      Object obj = map.get("tenantName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeStartDate")) {
      Object obj = map.get("chargeStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChargeStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setChargeStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setChargeStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setChargeStartDate(null);
      }
    }
    if(map.containsKey("chargeEndDate")) {
      Object obj = map.get("chargeEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChargeEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setChargeEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setChargeEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setChargeEndDate(null);
      }
    }
    if(map.containsKey("chargeType")) {
      Object obj = map.get("chargeType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payableAmount")) {
      Object obj = map.get("payableAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPayableAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPayableAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPayableAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayableAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayableAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discountMoney")) {
      Object obj = map.get("discountMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiscountMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("reconciliationDetailCode")) {
      Object obj = map.get("reconciliationDetailCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReconciliationDetailCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectNo")) {
      Object obj = map.get("projectNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxNo")) {
      Object obj = map.get("taxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyID")) {
      Object obj = map.get("companyID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingType")) {
      Object obj = map.get("billingType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillingType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unitPriceWithoutTax")) {
      Object obj = map.get("unitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reconciliationCode")) {
      Object obj = map.get("reconciliationCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReconciliationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reconciliationCreateTime")) {
      Object obj = map.get("reconciliationCreateTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReconciliationCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setReconciliationCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReconciliationCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReconciliationCreateTime(null);
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reconciliationSettleAccounts")) {
      Object obj = map.get("reconciliationSettleAccounts");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReconciliationSettleAccounts((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReconciliationSettleAccounts(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReconciliationSettleAccounts(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReconciliationSettleAccounts(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReconciliationSettleAccounts(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("oneTimeUnit")) {
      Object obj = map.get("oneTimeUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOneTimeUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeCycle")) {
      Object obj = map.get("chargeCycle");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeCycle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementAmount")) {
      Object obj = map.get("settlementAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSettlementAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSettlementAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSettlementAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSettlementAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSettlementAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setContractNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tenantName")) {
      Object obj = map.get("tenantName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProductName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chargeStartDate")) {
      Object obj = map.get("chargeStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setChargeStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setChargeStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setChargeStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setChargeStartDate(null);
      }
    }
    if(map.containsKey("chargeEndDate")) {
      Object obj = map.get("chargeEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setChargeEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setChargeEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setChargeEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setChargeEndDate(null);
      }
    }
    if(map.containsKey("chargeType")) {
      Object obj = map.get("chargeType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payableAmount")) {
      Object obj = map.get("payableAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPayableAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPayableAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPayableAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayableAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPayableAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("discountMoney")) {
      Object obj = map.get("discountMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDiscountMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDiscountMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDiscountMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDiscountMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDiscountMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("reconciliationDetailCode")) {
      Object obj = map.get("reconciliationDetailCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReconciliationDetailCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("projectNo")) {
      Object obj = map.get("projectNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProjectNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxNo")) {
      Object obj = map.get("taxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("companyID")) {
      Object obj = map.get("companyID");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyID((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billingType")) {
      Object obj = map.get("billingType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillingType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unitPriceWithoutTax")) {
      Object obj = map.get("unitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reconciliationCode")) {
      Object obj = map.get("reconciliationCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReconciliationCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reconciliationCreateTime")) {
      Object obj = map.get("reconciliationCreateTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setReconciliationCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setReconciliationCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReconciliationCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setReconciliationCreateTime(null);
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProductCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reconciliationSettleAccounts")) {
      Object obj = map.get("reconciliationSettleAccounts");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setReconciliationSettleAccounts((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setReconciliationSettleAccounts(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setReconciliationSettleAccounts(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReconciliationSettleAccounts(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setReconciliationSettleAccounts(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("oneTimeUnit")) {
      Object obj = map.get("oneTimeUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOneTimeUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chargeCycle")) {
      Object obj = map.get("chargeCycle");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeCycle((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("settlementAmount")) {
      Object obj = map.get("settlementAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSettlementAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSettlementAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSettlementAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSettlementAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSettlementAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
  }
}
