package com.xforceplus.ultraman.app.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * cost_statistics_data_source_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-03-20
 */
public enum CostStatisticsDataSourceEnum {

    _1("1", "易快报"),
    _2("2", "合思"),
    _3("3", "滴滴"),
    _4("4", "财务手工");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    CostStatisticsDataSourceEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CostStatisticsDataSourceEnum fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            default:
                return null;
        }
    }
}
