package com.xforceplus.ultraman.app.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * job_type
 * </p>
 *
 * @author ultraman
 * @since 2024-03-20
 */
public enum JobType {

    _1("1", "预付不限量");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    JobType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static JobType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            default:
                return null;
        }
    }
}
