package com.xforceplus.ultraman.app.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * statistics_dimension_type_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-03-20
 */
public enum StatisticsDimensionTypeEnum {

    _1("1", "Chargecode类型"),
    _2("2", "Chargecode所属部门"),
    _3("3", "经营分部"),
    _4("4", "产品大类");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    StatisticsDimensionTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static StatisticsDimensionTypeEnum fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            default:
                return null;
        }
    }
}
