package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.app.financialsettlement.entity.FinancialBasicBillDetail;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-03-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class FinancialTravelBillDetail extends FinancialBasicBillDetail {


  /**
   * 同行人编码
   */
  @TableField("triperCode")
  private String triperCode;

  /**
   * 同行人名称
   */
  @TableField("triperName")
  private String triperName;

  /**
   * 订单金额
   */
  @TableField("orderAmount")
  private String orderAmount;

  /**
   * 消费开始日期消费开始日期
   */
  @TableField("consumptionStartDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime consumptionStartDate;

  /**
   * 消费结束日期
   */
  @TableField("consumptionEndDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime consumptionEndDate;

  /**
   * 停车开始日期
   */
  @TableField("parkStartDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime parkStartDate;

  /**
   * 停车结束日期
   */
  @TableField("parkEndDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime parkEndDate;

  /**
   * 出差结束日期
   */
  @TableField("businessStartDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime businessStartDate;

  /**
   * 出差结束日期
   */
  @TableField("businessEndDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime businessEndDate;

  /**
   * 是否分摊
   */
  @TableField("ifApportion")
  private String ifApportion;

  /**
   * 分摊项目编号
   */
  @TableField("apportionProjectCode")
  private String apportionProjectCode;

  /**
   * 分摊项目名称
   */
  @TableField("apportionProjectName")
  private String apportionProjectName;

  /**
   * 分摊比例
   */
  @TableField("apportionRatio")
  private String apportionRatio;

  /**
   * 分摊金额
   */
  @TableField("apportionAmount")
  private String apportionAmount;

  /**
   * 发票形式
   */
  @TableField("invoiceForm")
  private String invoiceForm;

  /**
   * 结算方式
   */
  @TableField("clearingForm")
  private String clearingForm;

  /**
   * 税额
   */
  @TableField("invoiceTax")
  private String invoiceTax;

  /**
   * 发票号码
   */
  @TableField("invoiceNumber")
  private String invoiceNumber;

  /**
   * 发票张数
   */
  @TableField("invoiceQuantity")
  private String invoiceQuantity;

  /**
   * 登机牌
   */
  @TableField("boardingCheck")
  private String boardingCheck;

  /**
   * 保险费
   */
  private String premium;

  /**
   * 消费城市
   */
  @TableField("costCity")
  private String costCity;

  /**
   * 停车地点
   */
  @TableField("parkPlace")
  private String parkPlace;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;


  /**
   * 对一关联关系 关联对象 financialTravelReimbursementBill
   */
    private Long billSubDetailId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("triperCode", triperCode);
      map.put("triperName", triperName);
      map.put("orderAmount", orderAmount);
      map.put("consumptionStartDate", BocpGenUtils.toTimestamp(consumptionStartDate));
      map.put("consumptionEndDate", BocpGenUtils.toTimestamp(consumptionEndDate));
      map.put("parkStartDate", BocpGenUtils.toTimestamp(parkStartDate));
      map.put("parkEndDate", BocpGenUtils.toTimestamp(parkEndDate));
      map.put("businessStartDate", BocpGenUtils.toTimestamp(businessStartDate));
      map.put("businessEndDate", BocpGenUtils.toTimestamp(businessEndDate));
      map.put("ifApportion", ifApportion);
      map.put("apportionProjectCode", apportionProjectCode);
      map.put("apportionProjectName", apportionProjectName);
      map.put("apportionRatio", apportionRatio);
      map.put("apportionAmount", apportionAmount);
      map.put("invoiceForm", invoiceForm);
      map.put("clearingForm", clearingForm);
      map.put("invoiceTax", invoiceTax);
      map.put("invoiceNumber", invoiceNumber);
      map.put("invoiceQuantity", invoiceQuantity);
      map.put("boardingCheck", boardingCheck);
      map.put("premium", premium);
      map.put("costCity", costCity);
      map.put("parkPlace", parkPlace);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

       map.put("billSubDetail.id", billSubDetailId);
      return map;
  }

  public static FinancialTravelBillDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    FinancialTravelBillDetail entity = new FinancialTravelBillDetail();
    entity.setParentByOQSMap(map);
    if(map.containsKey("triperCode")) {
      Object obj = map.get("triperCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTriperCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("triperName")) {
      Object obj = map.get("triperName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTriperName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderAmount")) {
      Object obj = map.get("orderAmount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("consumptionStartDate")) {
      Object obj = map.get("consumptionStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setConsumptionStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setConsumptionStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setConsumptionStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setConsumptionStartDate(null);
      }
    }
    if(map.containsKey("consumptionEndDate")) {
      Object obj = map.get("consumptionEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setConsumptionEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setConsumptionEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setConsumptionEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setConsumptionEndDate(null);
      }
    }
    if(map.containsKey("parkStartDate")) {
      Object obj = map.get("parkStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setParkStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setParkStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setParkStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setParkStartDate(null);
      }
    }
    if(map.containsKey("parkEndDate")) {
      Object obj = map.get("parkEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setParkEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setParkEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setParkEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setParkEndDate(null);
      }
    }
    if(map.containsKey("businessStartDate")) {
      Object obj = map.get("businessStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBusinessStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setBusinessStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBusinessStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBusinessStartDate(null);
      }
    }
    if(map.containsKey("businessEndDate")) {
      Object obj = map.get("businessEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBusinessEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setBusinessEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBusinessEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBusinessEndDate(null);
      }
    }
    if(map.containsKey("ifApportion")) {
      Object obj = map.get("ifApportion");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIfApportion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("apportionProjectCode")) {
      Object obj = map.get("apportionProjectCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApportionProjectCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("apportionProjectName")) {
      Object obj = map.get("apportionProjectName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApportionProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("apportionRatio")) {
      Object obj = map.get("apportionRatio");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApportionRatio((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("apportionAmount")) {
      Object obj = map.get("apportionAmount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApportionAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceForm")) {
      Object obj = map.get("invoiceForm");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceForm((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("clearingForm")) {
      Object obj = map.get("clearingForm");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setClearingForm((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceTax")) {
      Object obj = map.get("invoiceTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNumber")) {
      Object obj = map.get("invoiceNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceQuantity")) {
      Object obj = map.get("invoiceQuantity");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceQuantity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("boardingCheck")) {
      Object obj = map.get("boardingCheck");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBoardingCheck((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("premium")) {
      Object obj = map.get("premium");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPremium((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("costCity")) {
      Object obj = map.get("costCity");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCostCity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("parkPlace")) {
      Object obj = map.get("parkPlace");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setParkPlace((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("billSubDetail.id")) {
        Object obj = map.get("billSubDetail.id");
      if(obj instanceof Long) {
        entity.setBillSubDetailId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setBillSubDetailId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }

  protected void setParentByOQSMap(Map map) {
    super.setByOQSMap(map);
  }

  protected void setByOQSMap(Map map) {
    super.setByOQSMap(map);
    if(map.containsKey("triperCode")) {
      Object obj = map.get("triperCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTriperCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("triperName")) {
      Object obj = map.get("triperName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTriperName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderAmount")) {
      Object obj = map.get("orderAmount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("consumptionStartDate")) {
      Object obj = map.get("consumptionStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setConsumptionStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setConsumptionStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setConsumptionStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setConsumptionStartDate(null);
      }
    }
    if(map.containsKey("consumptionEndDate")) {
      Object obj = map.get("consumptionEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setConsumptionEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setConsumptionEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setConsumptionEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setConsumptionEndDate(null);
      }
    }
    if(map.containsKey("parkStartDate")) {
      Object obj = map.get("parkStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setParkStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setParkStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setParkStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setParkStartDate(null);
      }
    }
    if(map.containsKey("parkEndDate")) {
      Object obj = map.get("parkEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setParkEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setParkEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setParkEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setParkEndDate(null);
      }
    }
    if(map.containsKey("businessStartDate")) {
      Object obj = map.get("businessStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBusinessStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setBusinessStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBusinessStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setBusinessStartDate(null);
      }
    }
    if(map.containsKey("businessEndDate")) {
      Object obj = map.get("businessEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBusinessEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setBusinessEndDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBusinessEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setBusinessEndDate(null);
      }
    }
    if(map.containsKey("ifApportion")) {
      Object obj = map.get("ifApportion");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIfApportion((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("apportionProjectCode")) {
      Object obj = map.get("apportionProjectCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApportionProjectCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("apportionProjectName")) {
      Object obj = map.get("apportionProjectName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApportionProjectName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("apportionRatio")) {
      Object obj = map.get("apportionRatio");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApportionRatio((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("apportionAmount")) {
      Object obj = map.get("apportionAmount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApportionAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceForm")) {
      Object obj = map.get("invoiceForm");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceForm((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("clearingForm")) {
      Object obj = map.get("clearingForm");
      if(obj != null) {
        if(obj instanceof String) {
          this.setClearingForm((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceTax")) {
      Object obj = map.get("invoiceTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceNumber")) {
      Object obj = map.get("invoiceNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceQuantity")) {
      Object obj = map.get("invoiceQuantity");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceQuantity((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("boardingCheck")) {
      Object obj = map.get("boardingCheck");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBoardingCheck((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("premium")) {
      Object obj = map.get("premium");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPremium((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("costCity")) {
      Object obj = map.get("costCity");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCostCity((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("parkPlace")) {
      Object obj = map.get("parkPlace");
      if(obj != null) {
        if(obj instanceof String) {
          this.setParkPlace((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("billSubDetail.id")) {
        Object obj = map.get("billSubDetail.id");
        if(obj instanceof Long) {
          this.setBillSubDetailId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBillSubDetailId(Long.parseLong((String)obj));
        }
      }
  }
}
