package com.xforceplus.ultraman.app.financialsettlement.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-07-01
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ContractTaxNoDetail implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 合同号
   */
  @TableField("contractCode")
  private String contractCode;

  /**
   * 产品code
   */
  @TableField("productCode")
  private String productCode;

  /**
   * 订单号-作废
   */
  @TableField("orderId")
  private String orderId;

  /**
   * 公司税号
   */
  @TableField("taxNum")
  private String taxNum;

  /**
   * 公司名称
   */
  @TableField("companyName")
  private String companyName;

  /**
   * 原始合同id
   */
  @TableField("contractId")
  private String contractId;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 操作类型-作废
   */
  @TableField("operateType")
  private String operateType;

  /**
   * 开通时间
   */
  @TableField("serviceOpenTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime serviceOpenTime;

  /**
   * 关闭时间
   */
  @TableField("serviceStopTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime serviceStopTime;

  /**
   * 产品名称
   */
  @TableField("productName")
  private String productName;

  /**
   * 开始计费时间
   */
  @TableField("startChargeTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime startChargeTime;

  /**
   * 设备类型枚举
   */
  @TableField("deviceType")
  private String deviceType;

  /**
   * 设备编号
   */
  @TableField("deviceNo")
  private String deviceNo;

  /**
   * 设备类型判重字段-内部
   */
  @TableField("deviceTypePk")
  private String deviceTypePk;

  /**
   * 设备编号判重字段-内部
   */
  @TableField("deviceNoPk")
  private String deviceNoPk;

  /**
   * 维护渠道
   */
  private String channel;

  /**
   * 公司名称
   */
  @TableField("companyNameWeb")
  private String companyNameWeb;

  /**
   * 产品名称
   */
  @TableField("productNameWeb")
  private String productNameWeb;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("contractCode", contractCode);
      map.put("productCode", productCode);
      map.put("orderId", orderId);
      map.put("taxNum", taxNum);
      map.put("companyName", companyName);
      map.put("contractId", contractId);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("operateType", operateType);
      map.put("serviceOpenTime", BocpGenUtils.toTimestamp(serviceOpenTime));
      map.put("serviceStopTime", BocpGenUtils.toTimestamp(serviceStopTime));
      map.put("productName", productName);
      map.put("startChargeTime", BocpGenUtils.toTimestamp(startChargeTime));
      map.put("deviceType", deviceType);
      map.put("deviceNo", deviceNo);
      map.put("deviceTypePk", deviceTypePk);
      map.put("deviceNoPk", deviceNoPk);
      map.put("channel", channel);
      map.put("companyNameWeb", companyNameWeb);
      map.put("productNameWeb", productNameWeb);
      return map;
  }

  public static ContractTaxNoDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ContractTaxNoDetail entity = new ContractTaxNoDetail();
    if(map.containsKey("contractCode")) {
      Object obj = map.get("contractCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderId")) {
      Object obj = map.get("orderId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxNum")) {
      Object obj = map.get("taxNum");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxNum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractId")) {
      Object obj = map.get("contractId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("operateType")) {
      Object obj = map.get("operateType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOperateType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serviceOpenTime")) {
      Object obj = map.get("serviceOpenTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setServiceOpenTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setServiceOpenTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setServiceOpenTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setServiceOpenTime(null);
      }
    }
    if(map.containsKey("serviceStopTime")) {
      Object obj = map.get("serviceStopTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setServiceStopTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setServiceStopTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setServiceStopTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setServiceStopTime(null);
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("startChargeTime")) {
      Object obj = map.get("startChargeTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStartChargeTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setStartChargeTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setStartChargeTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStartChargeTime(null);
      }
    }
    if(map.containsKey("deviceType")) {
      Object obj = map.get("deviceType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeviceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deviceNo")) {
      Object obj = map.get("deviceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeviceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deviceTypePk")) {
      Object obj = map.get("deviceTypePk");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeviceTypePk((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deviceNoPk")) {
      Object obj = map.get("deviceNoPk");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeviceNoPk((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("channel")) {
      Object obj = map.get("channel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyNameWeb")) {
      Object obj = map.get("companyNameWeb");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyNameWeb((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productNameWeb")) {
      Object obj = map.get("productNameWeb");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductNameWeb((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
