package com.xforceplus.ultraman.app.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * bs_employ_type_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-06-05
 */
public enum BsEmployTypeEnum {

    _0("0", "内部员工"),
    _2("2", "实习生"),
    _1("1", " 外部人员");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BsEmployTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BsEmployTypeEnum fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "2":
                return _2;
            case "1":
                return _1;
            default:
                return null;
        }
    }
}
