package com.xforceplus.ultraman.app.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * charge_code_type_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-06-05
 */
public enum ChargeCodeTypeEnum {

    SA("SA", "客户"),
    PS("PS", "机会"),
    DL("DL", "交付"),
    CSM("CSM", "CSM"),
    BU("BU", "BU"),
    IDLE("IDLE", "空闲"),
    SMB("SMB", "小B运营"),
    SS("SS", "销售"),
    TR("TR", "培训"),
    BG("BG", "数据增值"),
    CO("CO", "董办"),
    EB("EB", "生态业务"),
    FA("FA", "财务部"),
    GM("GM", "综合管理"),
    GS("GS", "光是"),
    HL("HL", "休假"),
    HR("HR", "人事部"),
    JF("JF", "交付管理"),
    KF("KF", "客户服务部"),
    OM("OM", "运维"),
    PD("PD", "产品"),
    PE("PE", "商联"),
    RD("RD", "研发"),
    SL("SL", "解决方案"),
    SO("SO", "战略运营中心"),
    SQ("SQ", "售前"),
    IS("IS", "系统服务部"),
    ZJ("ZJ", "专家"),
    DCSM("DCSM", "客户成功部"),
    LG("LG", "法务"),
    SP("SP", "出海专项"),
    PO("PO", "总裁办"),
    CSMT("CSMT", "CSMT");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ChargeCodeTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChargeCodeTypeEnum fromCode(String code){
        switch(code) {
            case "SA":
                return SA;
            case "PS":
                return PS;
            case "DL":
                return DL;
            case "CSM":
                return CSM;
            case "BU":
                return BU;
            case "IDLE":
                return IDLE;
            case "SMB":
                return SMB;
            case "SS":
                return SS;
            case "TR":
                return TR;
            case "BG":
                return BG;
            case "CO":
                return CO;
            case "EB":
                return EB;
            case "FA":
                return FA;
            case "GM":
                return GM;
            case "GS":
                return GS;
            case "HL":
                return HL;
            case "HR":
                return HR;
            case "JF":
                return JF;
            case "KF":
                return KF;
            case "OM":
                return OM;
            case "PD":
                return PD;
            case "PE":
                return PE;
            case "RD":
                return RD;
            case "SL":
                return SL;
            case "SO":
                return SO;
            case "SQ":
                return SQ;
            case "IS":
                return IS;
            case "ZJ":
                return ZJ;
            case "DCSM":
                return DCSM;
            case "LG":
                return LG;
            case "SP":
                return SP;
            case "PO":
                return PO;
            case "CSMT":
                return CSMT;
            default:
                return null;
        }
    }
}
