package com.xforceplus.ultraman.app.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * cost_statistics_type_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-06-05
 */
public enum CostStatisticsTypeEnum {

    D010("D010", "市场服务费"),
    D011("D011", "综合服务费"),
    D001("D001", "差旅费"),
    D002("D002", "业务招待费"),
    D003("D003", "行政办公费"),
    D004("D004", "房租物业"),
    D005("D005", "福利费"),
    D006("D006", "团建活动费"),
    D007("D007", "计算机及相关办公设备"),
    D008("D008", "培训会议费"),
    D009("D009", "云资通道及托管服务"),
    D012("D012", "其他产品服务费");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    CostStatisticsTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CostStatisticsTypeEnum fromCode(String code){
        switch(code) {
            case "D010":
                return D010;
            case "D011":
                return D011;
            case "D001":
                return D001;
            case "D002":
                return D002;
            case "D003":
                return D003;
            case "D004":
                return D004;
            case "D005":
                return D005;
            case "D006":
                return D006;
            case "D007":
                return D007;
            case "D008":
                return D008;
            case "D009":
                return D009;
            case "D012":
                return D012;
            default:
                return null;
        }
    }
}
