package com.xforceplus.ultraman.app.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * taken_status
 * </p>
 *
 * @author ultraman
 * @since 2024-06-05
 */
public enum TakenStatus {

    TAKEN("taken", "已认领"),
    NOT_TAKEN("notTaken", "未认领"),
    NO_NEED("noNeed", "无需认领"),
    PART_TAKEN("partTaken", "部分认领");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TakenStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TakenStatus fromCode(String code){
        switch(code) {
            case "taken":
                return TAKEN;
            case "notTaken":
                return NOT_TAKEN;
            case "noNeed":
                return NO_NEED;
            case "partTaken":
                return PART_TAKEN;
            default:
                return null;
        }
    }
}
